/*
 Wtv020sd16p.cpp - Library to control a WTV020-SD-16P module 
 Created by Diego J. Arevalo, August 6th, 2012 for  Arduino plaform
 Modified by Kamil Kanas, 17/5/2017 for mbed platforms
 Tested with FRDM KL25Z board
 Released into the public domain 9/6/2017.
 */

#include "mbed.h"
#include "WTV020SD16.h"

const unsigned int PLAY_PAUSE = 0xFFFE;
const unsigned int STOP = 0xFFFF;
const unsigned int VOLUME_MIN = 0xFFF0;
const unsigned int VOLUME_MAX = 0xFFF7;

/*Pin definition*/
DigitalOut _resetPin(PTB0);                             //reset pin   Output
DigitalOut _clockPin(PTB1);                             //clock pin   Output
DigitalOut _dataPin(PTB2);                              //data pin    Output
DigitalIn  _busyPin(PTB3);                              //busy pin    Input 



void Wtv020sd16p::reset(){
  
                                                           //Reset pulse.
  _clockPin=0;
  _resetPin=1;
  _resetPin=0;
  wait_ms(5);
  _resetPin=1;                                               //Reset idle to start bit. 
  _clockPin=1;
  wait_ms(300);
}

void Wtv020sd16p::playVoice(int voiceNumber){  
  sendCommand(voiceNumber);

  _busyPinState= _busyPin;

  while(_busyPinState==1){
    _busyPinState=_busyPin;
  }
}

void Wtv020sd16p::asyncPlayVoice(int voiceNumber){
  sendCommand(voiceNumber);
}

void Wtv020sd16p::stopVoice(){
  sendCommand(STOP);
}

void Wtv020sd16p::pauseVoice(){
  sendCommand(PLAY_PAUSE);
}

void Wtv020sd16p::mute(){
  sendCommand(VOLUME_MIN);
}

void Wtv020sd16p::unmute(){
  sendCommand(VOLUME_MAX);
}

void Wtv020sd16p::sendCommand(unsigned int command) {
  //Start bit Low level pulse.
 _clockPin=0;
  wait_ms(2);
  for (unsigned int mask = 0x8000; mask > 0; mask >>= 1) {
    //Clock low level pulse.
    _clockPin=0;
    wait_us(50);
    //Write data setup.
    if (command & mask) { 
      _dataPin=1;
    } else
     {
      
       _dataPin=0;
     }
    //Write data hold.
    wait_us(50);
    //Clock high level pulse.
    
    _clockPin=1;
    wait_us(100);
    if (mask>0x0001){
      //Stop bit high level pulse.
      wait_ms(2);      
    }
  }
  //Busy active high from last data bit latch.
  wait_ms(20);
}
