#include "mbed.h"

#define Y 1030//1050
#define Y1 750
#define R 340
#define Runder 300
#define T 1550//1650

#define wheel 70 //単位はmm, タイヤ直径 

/*エンコーダで使うピン*/
InterruptIn As(p9);
InterruptIn Bs(p10);

/*ジャイロとのSPI通信*/
SPISlave gyro(p11,p12,p13,p14);

/*エンコーダー系*/
Ticker Enc; //エンコーダータイマー割り込み
float sp_t=0.01;//この秒ごとにエンコーダーを測定

int setA=0,setB=0;
int Ec_count=0;
int cr=0;
float kyori;
float kyori_f;
float kyori_m45;
float kyori_m45_f;
float kyori_m90;
float kyori_m90_f;
float kyori_kaiten;
float kyori_plus;
float kyori_m45_plus;
float kyori_m90_plus;
float kyori_kaiten_plus;
float kyori_kaiten_f;
float kyori_15x;
float kyori_15x_f;
float kyori_15x_plus;
float kyori_30x;
float kyori_30x_f;
float kyori_30x_plus;
float kyori_45x;
float kyori_45x_f;
float kyori_45x_plus;
float kyori_x;
float kyori_x_f;
float kyori_x_plus;
float kyori_dh;
float kyori_dh2;
float kyori_dh_f;
float kyori_dh_plus;


float kyori_nobori;
float kyori_f_nobori;
int Ec_count_nobori;

int Ec_count_now;
int Ec_count_bef;

/*ジャイロ系*/
int flag=0;
int base_rot_data;
int rot_data;
int fixed_rot_data;
int pre_rot;
int rot;

/*リバーで使う*/  
int river_flag=0;
int river_theta;
float river_theta_f;
float Y_f;
float Z;
float phai;

void gyro_keisan(void);

////////////////////////////////////////////////////////////////////////////    
    
/******エンコーダー********/    
void set1() {setA=1; if(setB==0&&cr==0){cr=1;}else if(setB==1&&cr==3){cr=2;}}
void set2() {setA=0; if(setB==1&&cr==2){cr=3;}else if(setB==0&&cr==1){cr=0;Ec_count--;Ec_count_nobori--;}}
void set3() {setB=1; if(setA==1&&cr==1){cr=2;}else if(setA==0&&cr==0){cr=3;}}
void set4() {setB=0; if(setA==0&&cr==3){cr=0;Ec_count++;Ec_count_nobori++;}else if(setA==1&&cr==2){cr=1;}}

void Ec_r(void){
    As.rise(&set1); As.fall(&set2);Bs.rise(&set3);Bs.fall(&set4);
    }
    
void kyori_reset (void){
     Ec_count=0;
     Ec_count_now=0;
     Ec_count_bef=0;
     kyori=0;
     kyori_f=0;
     kyori_m45=0;
     kyori_m45_f=0;
     kyori_m90=0;
     kyori_m90_f=0;
     kyori_kaiten=0;
     kyori_plus=0;
     kyori_m45_plus=0;
     kyori_m90_plus=0;
     kyori_kaiten_plus=0;
     kyori_kaiten_f=0;
     kyori_15x=0;
     kyori_15x_f=0;
     kyori_15x_plus=0;
     kyori_30x=0;
     kyori_30x_f=0;
     kyori_30x_plus=0;
     kyori_45x=0;
     kyori_45x_f=0;
     kyori_45x_plus=0;
     kyori_x=0;
     kyori_x_f=0;
     kyori_x_plus=0;
     kyori_dh2=0;
     kyori_dh_f=0;
     kyori_dh_plus=0;
     kyori_dh=0;
    }   
    
void kyori_nobori_reset(void){
     kyori_nobori=0;
     kyori_f_nobori=0;
     Ec_count_nobori=0;
}     
    
void distance(void){
    Ec_r();
    gyro_keisan();
    Ec_count_now=Ec_count;
    kyori_f=Ec_count_now-Ec_count_bef; 
    
    kyori_f_nobori=Ec_count_nobori;
    kyori_nobori=kyori_f_nobori/500*3.14*wheel; 
    
    kyori_dh_f=kyori_f*cos(abs(fixed_rot_data)*3.14/180);//0->45
    kyori_dh_plus+=kyori_dh_f;
    kyori_dh=kyori_dh_plus/500*3.14*wheel;
    
    kyori_plus+=kyori_f;
    kyori=kyori_plus/500*3.14*wheel; 
    
    kyori_m45_f=kyori_f*cos(abs(-45-fixed_rot_data)*3.14/180);
    kyori_m45_plus+=kyori_m45_f;
    kyori_m45=kyori_m45_plus/500*3.14*wheel;
    
    kyori_m90_f=kyori_f*cos(abs(-90-fixed_rot_data)*3.14/180);
    kyori_m90_plus+=kyori_m90_f;
    kyori_m90=kyori_m90_plus/500*3.14*wheel;
    
    kyori_x_f=kyori_f*sin(-fixed_rot_data*3.14/180);
    kyori_x_plus+=kyori_x_f;
    kyori_x=kyori_x_plus/500*3.14*wheel;
    
    kyori_15x_f=kyori_f*sin((15-fixed_rot_data)*3.14/180);
    kyori_15x_plus+=kyori_15x_f;
    if(kyori_15x>30&&kyori_15x_f>0)kyori_15x_plus-=kyori_15x_f;
    if(kyori_15x<-30&&kyori_15x_f<0)kyori_15x_plus-=kyori_15x_f;
    kyori_15x=kyori_15x_plus/500*3.14*wheel;
    
    kyori_30x_f=kyori_f*sin((30-fixed_rot_data)*3.14/180);
    kyori_30x_plus+=kyori_30x_f;
    if(kyori_30x>30&&kyori_30x_f>0)kyori_30x_plus-=kyori_30x_f;
    if(kyori_30x<-30&&kyori_30x_f<0)kyori_30x_plus-=kyori_30x_f;
    kyori_30x=kyori_30x_plus/500*3.14*wheel;
    
    kyori_45x_f=kyori_f*sin((45-fixed_rot_data)*3.14/180);
    kyori_45x_plus+=kyori_45x_f;
    if(kyori_45x>30&&kyori_45x_f>0)kyori_45x_plus-=kyori_45x_f;
    if(kyori_45x<-30&&kyori_45x_f<0)kyori_45x_plus-=kyori_45x_f;
    kyori_45x=kyori_45x_plus/500*3.14*wheel;
    
    kyori_kaiten_f=kyori_f*cos((-fixed_rot_data)*3.14/180);//+15
    kyori_kaiten_plus+=kyori_kaiten_f;
    kyori_kaiten=kyori_kaiten_plus/500*3.14*wheel;
    Ec_count_bef=Ec_count_now;    
}    

void river_keisan(void){
    river_theta_f=river_theta;
    Y_f=Y;
    phai=atan((kyori_m45-R)*cos(river_theta_f*3.14/180)/(Y_f-(kyori_m45-R)*sin(river_theta_f*3.14/180)));
    phai=phai*180/3.14;
    Z=sqrt((kyori_m45-R)*(kyori_m45-R)+Y_f*Y_f-2*(kyori_m45-R)*Y_f*sin(river_theta_f*3.14/180));
    }  

/*******ジャイロ******/

int now_rotation(){
    if (gyro.receive()){
        rot=gyro.read();
        if(rot>32768)rot-=65536;
    }
    return rot;
}    

void gyro_keisan(){
    static int before,next;
    
    if(flag==300){      
    base_rot_data=now_rotation();
    next=before;
    }
    flag++;
    if(flag>301)flag=302;
    rot_data=now_rotation();
    fixed_rot_data=rot_data - base_rot_data;
    if(base_rot_data>0&&fixed_rot_data<-180){
         fixed_rot_data=180-abs(-180-fixed_rot_data);}
    if(base_rot_data<0&&fixed_rot_data>180){
         fixed_rot_data=-180+abs(180-fixed_rot_data);}
    if(fixed_rot_data>180){fixed_rot_data=pre_rot;}   
     pre_rot=fixed_rot_data; 
     
     before=next;    //フィルター
     next=fixed_rot_data;
     if(abs(before-next)>10)next=before;
    }
  
int gyro_pid(int th, int gyro_p,int gyro_i, int gyro_d){ //角度を合わせて進む用ＰＩＤ
    static int ans;
    static int p_d,g_bef,p_i;
    p_d+=fixed_rot_data-g_bef;
    p_i+=(th-fixed_rot_data);
    g_bef=fixed_rot_data;
    ans=naka-gyro_p*(th-fixed_rot_data)-gyro_i*p_i-gyro_d*p_d;
    return ans;
    }     
