#include "mbed.h"

/*設定するもの*/
#define MAX 3000  //白よりも少し大きい値
#define MIN 1500  //暗い色よりも少し小さい値
#define naka 1545 //サーボの真ん中
float kp=0.05;     //P係数
float kdir=0.025;     //傾きにかける係数 Dのような役割をする

SPI mcp(p5, p6, p7); // mosi, miso, sclk
DigitalOut mcs(p8);

AnalogIn ap(p19); 
AnalogIn bp(p18); 
AnalogIn cp(p17); 
AnalogIn dp(p16); 

/*mbedのＬＥＤ*/
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

/*スイッチ*/
DigitalIn switch_1(p26);
DigitalIn switch_2(p24);
DigitalIn switch_3(p23);
DigitalIn push_switch(p22);

float s1f,s2f,s3f,s4f;
int s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12;
int c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12;
int d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12;
int e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12;

int zure1,zure2,zure3,zure4,zure5;

float sa; 
int now;
int bef; 
int dir; 
int Dir;
int out;
int i;
int mcp_i;
int MAX_MIN;
int downhill;               //ダウンヒルのとき１になる。

void calibration(void); //キャリブレーション
void SA(void);          //saの上限下限
void PIN(void);         //cdsの生データ
void hosei(void);       //cdsの値を補正
void Find_White(void);  //大まかにどこにラインがあるのか読む
void LF(void);          //ライントレース

////////////////////////////////////////////////////////////////////////////////////

void calibration(void){
    
    while(1){           //暗い色で合わせる
        PIN();
        static int ccc=0;
        ccc++;
        d1+=s1-MIN;
        d2+=s2-MIN;
        d3+=s3-MIN;
        d4+=s4-MIN;
        d5+=s5-MIN;  
        d6+=s6-MIN;
        d7+=s7-MIN;  
        d8+=s8-MIN;  
        d9+=s9-MIN;  
        d10+=s10-MIN;
        d11+=s11-MIN;  
        d12+=s12-MIN;    
        out=0;
        if(ccc>29)break;
        }
    
        d1/=30;
        d2/=30;
        d3/=30;
        d4/=30;
        d5/=30;
        d6/=30;
        d7/=30;
        d8/=30;
        d9/=30;
        d10/=30;
        d11/=30;
        d12/=30;
        
        led1=1;
        led2=1;
        led3=1;
        led4=1;
        
        wait(3);
        
        led1=1;
        led2=0;
        led3=0;
        led4=1;
        
    
    while(1){       //白色で合わせる
        PIN();
        static int ccc=0;
        ccc++;
        c1+=MAX-s1;
        c2+=MAX-s2;
        c3+=MAX-s3;
        c4+=MAX-s4;
        c5+=MAX-s5;  
        c6+=MAX-s6;
        c7+=MAX-s7;  
        c8+=MAX-s8;  
        c9+=MAX-s9;  
        c10+=MAX-s10;
        c11+=MAX-s11;  
        c12+=MAX-s12;    
        out=0;
        if(ccc>29)break;
      }
        c1/=30;
        c2/=30;
        c3/=30;
        c4/=30;
        c5/=30;
        c6/=30;
        c7/=30;
        c8/=30;
        c9/=30;
        c10/=30;
        c11/=30;
        c12/=30;
    
        e1=c1+d1;
        e2=c2+d2;
        e3=c3+d3;
        e4=c4+d4;
        e5=c5+d5;
        e6=c6+d6;
        e7=c7+d7;
        e8=c8+d8;
        e9=c9+d9;
        e10=c10+d10;
        e11=c11+d11;
        e12=c12+d12;
        
        MAX_MIN=MAX-MIN;
    
    while(1){if(switch_1==0||switch_2==0||switch_3==0)break;}     //白に移動させた後スイッチを入れる
        led1=0;
        led2=0;
        led3=0;
        led4=0;
    }

void SA(void){
    if(sa<-300)sa=-300;
    if(sa>300)sa=300;
    }
    
void PIN(void){
    for(mcp_i=96;mcp_i<=124;mcp_i+=4) {
        mcs = 0;
        mcp.write(mcp_i);
        uint8_t high = mcp.write(0x00);
        uint8_t low = mcp.write(0x00);
        low = ( high << 5 ) | (low >> 2);
        high = high >> 3;
        int value = ( high << 8 ) | low;
        mcs = 1;
        if(mcp_i==96)s12=value;
        else if(mcp_i==100)s11=value; 
        else if(mcp_i==104)s10=value; 
        else if(mcp_i==108)s9=value; 
        else if(mcp_i==112)s8=value; 
        else if(mcp_i==116)s7=value; 
        else if(mcp_i==120)s6=value; 
        else if(mcp_i==124)s5=value; 
    }
    s4f=ap;
    s4=s4f*4095;
    s3f=bp;
    s3=s3f*4095;
    s2f=cp;
    s2=s2f*4095;
    s1f=dp;
    s1=s1f*4095;
}

void hosei(void){  //ＣｄＳの値を補正(上限下限を測って幅を一定にする)
     s1=MAX-(MAX-c1-s1)*MAX_MIN/(MAX_MIN-e1);
     s2=MAX-(MAX-c2-s2)*MAX_MIN/(MAX_MIN-e2);
     s3=MAX-(MAX-c3-s3)*MAX_MIN/(MAX_MIN-e3);
     s4=MAX-(MAX-c4-s4)*MAX_MIN/(MAX_MIN-e4);
     s5=MAX-(MAX-c5-s5)*MAX_MIN/(MAX_MIN-e5);
     s6=MAX-(MAX-c6-s6)*MAX_MIN/(MAX_MIN-e6);
     s7=MAX-(MAX-c7-s7)*MAX_MIN/(MAX_MIN-e7);
     s8=MAX-(MAX-c8-s8)*MAX_MIN/(MAX_MIN-e8);
     s9=MAX-(MAX-c9-s9)*MAX_MIN/(MAX_MIN-e9);
     s10=MAX-(MAX-c10-s10)*MAX_MIN/(MAX_MIN-e10);
     s11=MAX-(MAX-c11-s11)*MAX_MIN/(MAX_MIN-e11);
     s12=MAX-(MAX-c12-s12)*MAX_MIN/(MAX_MIN-e12);     
   
    } 
    
void Find_White(void){  //大まかにどこにラインがあるのか読む
    if(s1>s2&&s1>s3&&s1>s4&&s1>s5&&s1>s6&&s1>s7&&s1>s8&&s1>s9&&s1>s10&&s1>s11&&s1>s12){now=6; i=1;}
    else if(s2>s1&&s2>s3&&s2>s4&&s2>s5&&s2>s6&&s2>s7&&s2>s8&&s2>s9&&s2>s10&&s2>s11&&s2>s12){now=5; i=1;}
    else if(s3>s1&&s3>s2&&s3>s4&&s3>s5&&s3>s6&&s3>s7&&s3>s8&&s3>s9&&s3>s10&&s3>s11&&s3>s12){now=4; i=1;}
    else if(s4>s1&&s4>s2&&s4>s3&&s4>s5&&s4>s6&&s4>s7&&s4>s8&&s4>s9&&s4>s10&&s4>s11&&s4>s12){now=3; i=1;}
    else if(s5>s1&&s5>s2&&s5>s3&&s5>s4&&s5>s6&&s5>s7&&s5>s8&&s5>s9&&s5>s10&&s5>s11&&s5>s12){now=2; i=1;}
    else if(s6>s1&&s6>s2&&s6>s3&&s6>s4&&s6>s6&&s6>s7&&s6>s8&&s6>s9&&s6>s10&&s6>s11&&s6>s12){now=1; i=1;}
    else if(s7>s1&&s7>s2&&s7>s3&&s7>s4&&s7>s5&&s7>s6&&s7>s8&&s7>s9&&s7>s10&&s7>s11&&s7>s12){now=-1; i=1;}
    else if(s8>s1&&s8>s2&&s8>s3&&s8>s4&&s8>s5&&s8>s6&&s8>s7&&s8>s9&&s8>s10&&s8>s11&&s8>s12){now=-2; i=1;}
    else if(s9>s1&&s9>s2&&s9>s3&&s9>s4&&s9>s5&&s9>s6&&s9>s7&&s9>s8&&s9>s10&&s9>s11&&s9>s12){now=-3; i=1;}
    else if(s10>s1&&s10>s2&&s10>s3&&s10>s4&&s10>s5&&s10>s6&&s10>s7&&s10>s8&&s10>s9&&s10>s11&&s10>s12){now=-4; i=1;}
    else if(s11>s1&&s11>s2&&s11>s3&&s11>s4&&s11>s5&&s11>s6&&s11>s7&&s11>s8&&s11>s9&&s11>s10&&s11>s12){now=-5; i=1;}
    else if(s12>s1&&s12>s2&&s12>s3&&s12>s4&&s12>s5&&s12>s6&&s12>s7&&s12>s8&&s12>s9&&s12>s10&&s12>s11){now=-6; i=1;}
    }

    
void LF(void){  //ライントレース

/*zureの値は上り・リバーとダウンヒルで分ける.*/
    if(downhill==0){
        zure1=25;                                             
        zure2=50;
        zure3=75;//100
        zure4=150;//175
        zure5=250;//300
        }
    
   PIN();
   hosei();
   if(i==0){                
     Find_White();
     }
     
   if(i==1){
      dir+=bef;  //加算式にする。
      if(dir>1000)dir=1000;
      else if(dir<-1000)dir=-1000;
      Dir=dir*kdir;
     if(Dir>50)Dir=50;
     else if(Dir<-50)Dir=-50;
     
     switch(now){
      case -6:       
       sa=zure5+(s1-s2)*kp;
       SA();
       out=naka-Dir-sa;
       bef=now; i=0;
       break;
       
       case -5:
       if(s1>s3)sa=zure5+(s1-s2)*kp;
       else {sa=zure4+(s2-s3)*kp; if(sa>zure5)sa=zure5;}
       SA();
       out=naka-Dir-sa;
       bef=now; i=0;
       break;
       
       case -4: 
       if(s2>s4){sa=zure4+(s2-s3)*kp; if(sa>zure5)sa=zure5;}
       else {sa=zure3+(s3-s4)*kp; if(sa>zure4)sa=zure4;}
       SA();
       out=naka-Dir-sa;
       bef=now; i=0;
       break;
       
       case -3: 
       if(s3>s5){sa=zure3+(s3-s4)*kp; if(sa>zure4)sa=zure4;}
       else {sa=zure2+(s4-s5)*kp; if(sa>zure3)sa=zure3;}
       SA();
       out=naka-Dir-sa;
       bef=now; i=0;
       break;
       
       case -2: 
       if(s4>s6){sa=zure2+(s4-s5)*kp; if(sa>zure3)sa=zure3;}
       else {sa=zure1+(s5-s6)*kp; if(sa>zure2)sa=zure2;}
       SA();
       out=naka-Dir-sa;
       bef=now; i=0;
       break;
       
       case -1: 
       if(s5>s7){sa=zure1+(s5-s6)*kp; if(sa>zure2)sa=zure2;}
       else {sa=(s6-s7)*kp; if(sa>zure1)sa=zure1;}
       SA();
       out=naka-Dir-sa;
       bef=now; i=0;
       break;
       
       case 1: 
       if(s6>s8){sa=(s7-s6)*kp; if(sa>zure1)sa=zure1;}
       else {sa=zure1+(s8-s7)*kp; if(sa>zure2)sa=zure2;}
       SA();
       out=naka+Dir+sa;
       bef=now; i=0;
       break;
       
       case 2: 
       if(s7>s9){sa=zure1+(s8-s7)*kp; if(sa>zure2)sa=zure2;}
       else {sa=zure2+(s9-s8)*kp; if(sa>zure3)sa=zure3;}
       SA();
       out=naka+Dir+sa;
       bef=now; i=0;
       break;
       
       case 3: 
       if(s8>s10){sa=zure2+(s9-s8)*kp; if(sa>zure3)sa=zure3;}
       else {sa=zure3+(s10-s9)*kp; if(sa>zure4)sa=zure4;}
       SA();
       out=naka+Dir+sa;
       bef=now; i=0;
       break;
       
       case 4: 
       if(s9>s11){sa=zure3+(s10-s9)*kp; if(sa>zure4)sa=zure4;}
       else {sa=zure4+(s11-s10)*kp; if(sa>zure5)sa=zure5;}
       SA();
       out=naka+Dir+sa;
       bef=now; i=0;
       break;
       
       case 5: 
       if(s10>s12){sa=zure4+(s11-s10)*kp; if(sa>zure5)sa=zure5;}
       else sa=zure5+(s12-s11)*kp;
       SA();
       out=naka+Dir+sa;
       bef=now; i=0;
       break;
       
       case 6: 
       sa=zure5+(s12-s11)*kp;
       SA();
       out=naka+Dir+sa;
       bef=now; i=0;
       break;
           
      default:
       i=0;
       break;
     
     }
     if(out>2200)out=2200;
     if(out<800)out=800;
        }
    }      