#include "mbed.h"

DigitalOut ledL( PTB8);
DigitalOut ledR( PTE5);
BusOut ledLL( PTB8, PTB9);
BusOut ledRR( PTE5, PTE4);  //わざと右から書いてます

AnalogIn sensorR( PTB1);
AnalogIn sensorL( PTB3);
AnalogIn sensorCR( PTB0);
AnalogIn sensorCL( PTB2);

//モータ1
BusOut Mlefti(PTA1, PTA2);
PwmOut Mleftp(PTD4);
//モータ2
BusOut Mrighti(PTC0, PTC7);
PwmOut Mrightp(PTA12);

float white = 0.13, black = 0.011, gray = 0.07;   //閾値（再定義必須）
float whiteL = 0.0085, blackL = 0.004, grayL = 0.005; //弱いセンサ用
float whiteR = 0.1, blackR = 0.011, grayR = 0.05;
float white_tunnel, black_tunnel, gray_tunnel;
float sensor[4];    //sensor[0]:sensorL ... sensor[3]:sensorR
float kp = 0.3; //Pゲイン
float pr, pl;

void go_straight_p(){
    if( pr < (gray - black) / (white - black)){
        Mrighti = 2;
        Mrightp = (kp * pl + 0.3) * 1.0f;
        Mlefti = 1;
        Mleftp = (kp * pl + 0.3) * 1.0f;
        ledR = 1;
        ledL = 0;
    } else if( pl < (gray - black) / (white - black)){
        Mrighti = 1;
        Mrightp = (kp * pr + 0.3) * 1.0f;
        Mlefti = 2;
        Mleftp = (kp * pl + 0.3) * 1.0f;
        ledR = 0;
        ledL = 1;
    } else{
        Mrighti = 1;
        Mrightp = (kp * pr + 0.3) * 1.0f;
        Mlefti = 1;
        Mleftp = (kp * pl + 0.3) * 1.0f;
        ledR = 0;
        ledL = 0;
    }
}

void go_straight_check(){   //モータドライバの調子の確認用
    Mrighti = 1;
    Mrightp = 0.8f;
    Mlefti = 1;
    Mleftp = 0.8f;
}

void stop_point(){
    Mrighti = 2;
    Mrightp = 0.5f;
    Mlefti = 2;
    Mleftp = 0.5f;
    wait(0.05);
    Mrighti = 0;
    Mlefti = 0;
    ledRR = 2;
    ledLL = 2;
}

int main() {
    go_straight_check();
    wait(0.2); 
    while(1) {
        sensor[0] = sensorL.read();
        sensor[1] = sensorCL.read();
        sensor[2] = sensorCR.read();
        sensor[3] = sensorR.read();
    
        pr = (sensor[2] - black) / (white - black);
        pl = (sensor[1] - black) / (white - black);
        
        go_straight_p();
        if( sensor[0] <= blackL && sensor[3] <= blackR){
            stop_point();
            break;
        }
    }
}