#pragma once
// TCP Echo server
// 02/09/2011


/*

Hi there!

*/

#ifndef _LINE_UTIL_H
#define _LINE_UTIL_H


#define LINE_MAX_LEN 100
#define NUM_LINES 51


#include <time.h>


typedef enum
{
  LINE_SRC_INVALID,    // 0 - Invalid Source
  LINE_SRC_DEBUG,   // 1 - Internal DEBUG Source
  LINE_SRC_HOST,    // 2 - HOST USB Port Source
  LINE_SRC_GPS,     // 3 - GPS TTL Port Source
  LINE_SRC_IMU,     // 4 - IMU TTL Port Source
  LINE_SRC_WHEEL,   // 5 - Wheel Source (serial encoder or QEI)
  LINE_SRC_BUTTONS, // 6 - GPIO Buttons Source
  LINE_SRC_NONE,
  LINE_SRC_COUNT, // 9 - Invalid source
}LINE_SRC_T;


extern const char* const LINE_SRC_NAMES[LINE_SRC_COUNT];  


// This is a type to store a timestamp for each line.
typedef struct _LINE_T
{
  LINE_SRC_T source; // Keep track of who's talking
  time_t timestamp; // 32bit unsigned unix epochtime
  uint32_t usec; // 32 bit unsigned microsecond counter
  uint16_t len; // length of line
  char line[LINE_MAX_LEN+1]; // Add an extra index to null-terminate.
}LINE_T;


unsigned int strip_crlf(char* src);


unsigned int SLines_get_fill();


unsigned int SLines_get_capacity();


LINE_T* SLine_put(LINE_T* line);


LINE_T* SLine_get();


void SLine_remove();


void SLine_clear();


void SLine_put_control(bool ctrl);


#endif