#include "mbed.h"

Serial pc(USBTX, USBRX);
Ticker serial_time;
DigitalIn encoderA(p19);
DigitalIn encoderB(p18);

int AB = 0;
int pre_AB = 0;
int count = 0;
double deg = 0;

void output(){
 pc.printf("count = %d\ndistance = %.1lf\nAB = %d", count, deg, AB);
 }
 
int main() {
    serial_time.attach(&output, 1.0);
    while(1) {
        AB = 00;
        if(encoderA) AB += 10;
        if(encoderB) AB += 01;
        
        if(AB == 00){
            if(pre_AB == 10)    count++;
            if(pre_AB == 01)    count--;
        }
        if(AB == 01){
            if(pre_AB == 00)    count++;
            if(pre_AB == 11)    count--;
        }
        if(AB == 10){
            if(pre_AB == 11)    count++;
            if(pre_AB == 00)    count--;
        }
        if(AB == 11){
            if(pre_AB == 01)    count++;
            if(pre_AB == 10)    count--;
        }
        deg = (double)count * 0.25;
        pre_AB = AB;
    }
}