#include "mbed.h"
#include "lancer_speaker.h"


Speaker::Speaker(PinName pin): _pin(pin){
    _pin = 0;
}

void Speaker::tone(int freq, int duration)
{
    _duration = duration;
    _freq = freq;
    _time.attach_us(this, &Speaker::flip, 500000/_freq);
}

void Speaker::noTone()
{
    _time.detach();
}

void Speaker::flip()
{
    _pin = !_pin;
    if(_duration < _count*500/_freq){
        _count = 0;
        _time.detach();
    }
    _count++;
}