#include "mbed.h" // Include the library of Mbed
#include "C12832.h"  // Include the library of the specific LCD
#include "mbed_trace.h"
#include "mbed_events.h"
#include "LoRaWANInterface.h"
#include "SX1276_LoRaRadio.h"

#define YELLOWBLINKINGDURATION 10
#define REDLIGHTONDURATION 10
// The port we're sending and receiving on
#define MBED_CONF_LORA_APP_PORT     15
//#define DEVICEID Jacqueline

DigitalOut yellowled(p15, 1); // Initializing the yellow light ON (same as yellowled = 1)
DigitalOut redled(p17, 0); // Initializing the Red light to OFF (same as redled = 0)
PwmOut speaker(p21);//pin for sound speaker
InterruptIn pedestrianbutton(p16);

C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11); // create an instance of LCD

int state = 0;  // State variable indicating that YELLOW LIGHT IS ON

char pedestrianAdvert[] = "2 COFFEES FOR THE PRICE OF 1. ONLY AT CAMELIA";
char carDriverAdvert[] = "RECEIVE 5%% REDUCTION ON YOUR FULL TANK ....";
char deviceId[] = "KALISA_220014146";

// Device credentials, register device as OTAA in The Things Network and copy credentials here
static uint8_t DEV_EUI[] = { 0x26, 0x10, 0x20, 0x20, 0x11, 0x11, 0x20, 0x20 };
static uint8_t APP_EUI[] = { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x03, 0x74, 0x72 };
static uint8_t APP_KEY[] = { 0x75, 0x57, 0x56, 0x65, 0xB1, 0x8A, 0x17, 0x52, 0x1B, 0x2D, 0x45, 0xD9, 0xFC, 0x90, 0x9E, 0x05 };


// Peripherals (LoRa radio, temperature sensor and button)
SX1276_LoRaRadio radio(D11, D12, D13, D10, A0, D2, D3, D4, D5, D8, D9, NC, NC, NC, NC, A4, NC, NC);
InterruptIn btn(BUTTON1);
// EventQueue is required to dispatch events around
static EventQueue ev_queue;
// Constructing Mbed LoRaWANInterface and passing it down the radio object.
static LoRaWANInterface lorawan(radio);
// Application specific callbacks
static lorawan_app_callbacks_t callbacks;
// LoRaWAN stack event handler
static void lora_event_handler(lorawan_event_t event);

// Send a message over LoRaWAN
static void send_message(int value) {
    uint8_t tx_buffer[50] = { 0 };
     time_t seconds = time(NULL);
    // Sending strings over LoRaWAN is not recommended
    sprintf((char*) tx_buffer, "{\"deviceId\":\"%s\", \"timestamp\":%ld,\"value\":%d}", deviceId, (long int)seconds, value);
    int packet_len = strlen((char*) tx_buffer);
    printf("Sending %d bytes: \"%s\"\n", packet_len, tx_buffer);
    int16_t retcode = lorawan.send(MBED_CONF_LORA_APP_PORT, tx_buffer, packet_len, MSG_UNCONFIRMED_FLAG);
    // for some reason send() returns -1... I cannot find out why, the stack returns the right number. I feel that this is some weird Emscripten quirk
    if (retcode < 0) {
        retcode == LORAWAN_STATUS_WOULD_BLOCK ? printf("send - duty cycle violation\n")
                : printf("send() - Error code %d\n", retcode);
        return;
    }
    printf("%d bytes scheduled for transmission\n", retcode);
}

int initialize_lora() {
    if (DEV_EUI[0] == 0x0 && DEV_EUI[1] == 0x0 && DEV_EUI[2] == 0x0 && DEV_EUI[3] == 0x0 && DEV_EUI[4] == 0x0 && DEV_EUI[5] == 0x0 && DEV_EUI[6] == 0x0 && DEV_EUI[7] == 0x0) {
        printf("Set your LoRaWAN credentials first!\n");
        return -1;
    }
    printf("Press BUTTON1 to stop cars and have right to cross the road!!!!\n");
    // Enable trace output for this demo, so we can see what the LoRaWAN stack does
    mbed_trace_init();
    if (lorawan.initialize(&ev_queue) != LORAWAN_STATUS_OK) {
        printf("LoRa initialization failed!\n");
        return -1;
    }
        // prepare application callbacks
    callbacks.events = mbed::callback(lora_event_handler);
    lorawan.add_app_callbacks(&callbacks);
    // Disable adaptive data rating
    if (lorawan.disable_adaptive_datarate() != LORAWAN_STATUS_OK) {
        printf("disable_adaptive_datarate failed!\n");
        return -1;
    }
    lorawan.set_datarate(5); // SF7BW125
    lorawan_connect_t connect_params;
    connect_params.connect_type = LORAWAN_CONNECTION_OTAA;
    connect_params.connection_u.otaa.dev_eui = DEV_EUI;
    connect_params.connection_u.otaa.app_eui = APP_EUI;
    connect_params.connection_u.otaa.app_key = APP_KEY;
    connect_params.connection_u.otaa.nb_trials = 3;

    lorawan_status_t retcode = lorawan.connect(connect_params);

    if (retcode == LORAWAN_STATUS_OK ||
        retcode == LORAWAN_STATUS_CONNECT_IN_PROGRESS) {
    }
    else {
        printf("Connection error, code = %d\n", retcode);
        return -1;
    }

    printf("Connection - In Progress ...\r\n");
    // make your event queue dispatching events forever
    ev_queue.dispatch_forever();
    return 0;
}
void play_tone(float frequency, float volume, int interval, int rest) {
    speaker.period(1.0 / frequency);
    speaker = volume;
    wait(interval);
    speaker = 0.0;
    wait(rest);
}

/**
 * Blinking a yellow LED.
 *
 * @param duration length of time to blink .
 */
static void yellowblinking(int duration){
    int counter=0; 
    while(counter < duration)
    {
           
 counter+=1;
        yellowled = !yellowled;
        wait(1);
  
    }
    yellowled = 0;
   // state=2;
}

/**
 * Crossing pedestrian.
 *
 * @param duration length of time for pedestrian to cross.
 */
static void pedestriancrossing(int duration){
    redled = 1;
    
    int counter=0; 
    while(counter < duration)
    {
        play_tone(200.0, 0.5, 1, 0);//play sound to help people with disabilities to know time to cross the road
        //play_tone(150.0, 0.5, 1, 0);
        //play_tone(125.0, 0.5, 1, 0); 
        counter+=1;
      
        wait(1);
    }
    redled = 0;
    yellowled = 1;
    //state=0;
    }


/**
 * Display content on LCD.
 *
 * @param advert The advertising text to be displayed.
 */
static void display(char *advert) {
    lcd.cls();  // Clear LCD
    lcd.locate(10, 5); // get cursor to position x=3px and y=5px
    lcd.printf(advert); // Write text into LCD buffer
    lcd.copy_to_lcd();
}


/**
 * Callback (Interrupt Service Routine) when a bouton is clicked.
 *
 */
void pedestrian_isr() {
     wait(1);
     //send_message(state);
     if (state == 0) // YELLOW IS ON AND RED IS OFF
     {
        state = 1; // YELLOW IS BLINKING AND RED IS OFF
        send_message(state);
         //send_message(deviceId, 123456, 2);
        display(pedestrianAdvert);
        yellowblinking(YELLOWBLINKINGDURATION);
        wait(1);
        state = 2;// YELLOW IS OFF AND RED IS ON
     }
    if(state==2){
        send_message(2);
        display(carDriverAdvert);
        pedestriancrossing(REDLIGHTONDURATION);
         wait(1);
         state = 0;
        }
    if(state==0){
        send_message(0);
        lcd.cls();
     }
     }
     //if(state == 2) // RED 
     //{
         // extend the duration of RED by 5 seconds
    // }
//}

int main() {
    pedestrianbutton.rise(ev_queue.event(&pedestrian_isr)); // Registering an ISR for button click
    initialize_lora();
}

// Event handler
static void lora_event_handler(lorawan_event_t event) {
    switch (event) {
        case CONNECTED:
            printf("Connection - Successful\n");
            break;
        case DISCONNECTED:
            ev_queue.break_dispatch();
            printf("Disconnected Successfully\n");
            break;
        case TX_DONE:
            printf("Message Sent to Network Server\n");
            break;
        case TX_TIMEOUT:
        case TX_ERROR:
        case TX_CRYPTO_ERROR:
        case TX_SCHEDULING_ERROR:
            printf("Transmission Error - EventCode = %d\n", event);
            break;
        case JOIN_FAILURE:
            printf("OTAA Failed - Check Keys\n");
            break;
        default:
            MBED_ASSERT("Unknown Event");
    }
}
    myled2 = 0;            //LED2 is OFF
    myled3 = 0;            //LED3 is OFF

    mybutton.fall(&changetempo);  //Interrupt to change tempo

    while(1) {
        myled1 = 1;   // LED2 is ON
        wait(tempo);  // wait tempo
        myled1 = 0;   // LED2 is OFF
        myled2 = 1;   // LED1 is ON
        wait(tempo);  // wait tempo
        myled2 = 0;   // LED1 is OFF
        myled3 = 1;   // LED3 is ON
        wait(tempo);  // wait tempo
        myled3 = 0;   // LED3 is OFF
    }
}
