#include "map.h"

#include "globals.h"
#include "graphics.h"

/**
 * The Map structure. This holds a HashTable for all the MapItems, along with
 * values for the width and height of the Map.
 */
struct Map {
    HashTable* items;
    int w, h;
};

/**
 * Storage area for the maps.
 * This is a global variable, but can only be access from this file because it
 * is static.
 */
static Map map[2];
static int active_map=0;

/**
 * The first step in HashTable access for the map is turning the two-dimensional
 * key information (x, y) into a one-dimensional unsigned integer.
 * This function should uniquely map (x,y) onto the space of unsigned integers.
 */
static unsigned XY_KEY(int X, int Y) {
    // TODO: Fix me!
    return X* map[active_map].h + Y;
}

/**
 * This is the hash function actually passed into createHashTable. It takes an
 * unsigned key (the output of XY_KEY) and turns it into a hash value (some
 * small non-negative integer).
 */
unsigned map_hash(unsigned key)
{
    
    return key % NUMBUCK;// key mod number of buckets- returns the right bucket number that the key is in
}

void maps_init()
{
    map[0].items =createHashTable(map_hash, NUMBUCK); //initialize hash table w numbuck from globals.h
    map[0].w= 50; // set width- in globals.h
    map[0].h= 50; //set height- in global    map[0].items =createHashTable(map_hash, NUMBUCK); //initialize hash table w numbuck from globals.h
    map[1].items =createHashTable(map_hash, NUMBUCK);
    map[1].w= 50; // set width- in globals.h
    map[1].h= 50; //set height- in globals.hs.h
    
    
}

Map* get_active_map()
{
    // There's only one map
    return & map[active_map];
}

Map* set_active_map(int m)
{
    active_map = m; 
    return & map[active_map];
}

#define WALL 0
#define PLANT 1
#define GATE 2
#define NPC 3


void print_map()
{
    // As you add more types, you'll need to add more items to this array.
    char lookup[] = {'W', 'P'};
    for(int y = 0; y < map_height(); y++)
    {
        for (int x = 0; x < map_width(); x++)
        {
            MapItem* item = get_here(x,y);
            if (item) pc.printf("%c", lookup[item->type]);
            else pc.printf(" ");
        }
        pc.printf("\r\n");
    }
}

int map_width()
{
    Map* m= get_active_map();//get the active map
    return m -> w; //returns the active map's width
}

int map_height()
{
    Map* m= get_active_map(); //get the active map
    return m -> h; // returns the active map's height
}

int map_area()
{
    Map * m= get_active_map();
    return (m-> h * m-> w);
}

MapItem* get_north(int x, int y)
{
    Map *m= get_active_map();
    int key= XY_KEY(x,y+1);//north is y+1
    return (MapItem *) getItem(map-> items, key); //gets the item corresponding to that key- uses hash_table.c function
}

MapItem* get_south(int x, int y)
{
    Map *m= get_active_map();
    int key= XY_KEY(x,y-1);//south is y-1
    return (MapItem *) getItem(map-> items, key); //gets the item corresponding to that key- uses hash_table.c function
}

MapItem* get_east(int x, int y)
{
    Map *m= get_active_map();
    int key= XY_KEY(x+1,y);//east is x+1
    return (MapItem *) getItem(map-> items, key); //gets the item corresponding to that key- uses hash_table.c function
}

MapItem* get_west(int x, int y)
{
    Map *m= get_active_map();
    int key= XY_KEY(x-1,y);//west is x-1
    return (MapItem *) getItem(map-> items, key); //gets the item corresponding to that key- uses hash_table.c function
}

MapItem* get_here(int x, int y)
{
    Map *m= get_active_map();
    int key= XY_KEY(x,y);
    return (MapItem *) getItem(map-> items, key); //gets the item corresponding to that key- uses hash_table.c function
}

int check_type(int x, int y)
{
    
}
void map_erase(int x, int y)
{
    Map *map= get_active_map();//gets current map
    int key= XY_KEY(x,y);//gets current key
    MapItem* item = (MapItem *) getItem(map-> items, key);//current item
    //condition for erase//// if key found???
    if (item -> type == GATE) deleteItem(map->items, key); // if gate erase previous map-
    set_active_map(active_map +1); // set the active map to be the next map
}

void add_wall(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++)
    {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = WALL;
        w1->draw = draw_wall;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

void add_plant(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = PLANT;
    w1->draw = draw_plant;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

//add other things