#include "mbed.h"
#include "DHT.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"

#define ECHO_SERVER_PORT   7

#include "mbed.h"
 
int arrivedcount = 0;
DigitalOut sw1(D9);
DigitalOut sw2(D10);
DigitalOut sw3(D11);
 

void sw1_messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    
    if( strncmp((char*)message.payload,"1",message.payloadlen) == 0 ){
        sw1 = 1;
    } else{
        sw1 = 0;
    }
}

void sw2_messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    if( strncmp((char*)message.payload,"1",message.payloadlen) == 0 ){
        sw2 = 1;
    } else{
        sw2 = 0;
    }
}

void sw3_messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    if( strncmp((char*)message.payload,"1",message.payloadlen) == 0 ){
        sw3 = 1;
    } else{
        sw3 = 0;
    }
}

void baud(int baudrate) {
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

int main (void)
{
    DHT sensor(D4, DHT11);
    DigitalOut myled(LED1);
    
    sw1 = 0; sw2 = 0; sw3 = 0;
    baud(115200);
    printf("Wait a second...\r\n");
    
    
    myled = 0;
    
    MQTTEthernet ipstack = MQTTEthernet();
    printf("IP Address : %s\r\n",ipstack.getEth().getIPAddress());
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    
    char* hostname = "192.168.1.213";
    printf("connect to %s\r\n",hostname);
    int port = 1883;
    
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
    {
        printf("rc from TCP connect is %d\n", rc);
        return 0;
    }
    printf("TCP connection is successful\r\n");
        
    char MQTTClientID[30];
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    sprintf(MQTTClientID,"WIZwiki-W7500-client-%d",rand()%1000);
    data.clientID.cstring = MQTTClientID;
    data.username.cstring = "";
    data.password.cstring = "";  
    
    if ((rc = client.connect(data)) != 0)
    {
        printf("rc from MQTT connect is %d\r\n", rc);
        return 0;
    }
    printf("MQTT connection is successful\r\n");

        
    char *sw1 = "/wiznet/sw1";
    if ((rc = client.subscribe(sw1, MQTT::QOS1, sw1_messageArrived)) != 0)
    {
        printf("rc from MQTT subscribe is %d\r\n", rc);
        return 0;
    }
    printf("Added subscription for sw1\r\n");
    
    char *sw2 = "/wiznet/sw2";
    if ((rc = client.subscribe(sw2, MQTT::QOS1, sw2_messageArrived)) != 0)
    {
        printf("rc from MQTT subscribe is %d\r\n", rc);
        return 0;
    }
    printf("Added subscription for sw2\r\n");
        
    char *sw3 = "/wiznet/sw3";
    if ((rc = client.subscribe(sw3, MQTT::QOS1, sw3_messageArrived)) != 0)
    {
        printf("rc from MQTT subscribe is %d\r\n", rc);
        return 0;
    }
    printf("Added subscription for sw3\r\n");

    MQTT::Message message;
    char buf[100];
    int error = 0;
    float hum = 0.0f, temp = 0.0f;
    char i = 0;
    while (true)
    {
        if(i > 100) i = 0;
        error = sensor.readData();
        if (0 == error) {
            hum = sensor.ReadHumidity();
            temp = sensor.ReadTemperature(CELCIUS);
        }
        message.qos = MQTT::QOS1;
        message.retained = false;
        message.dup = false;
        
        sprintf(buf, "%3.1f", hum);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("/wiznet/humidity",message);
        printf("publish humidity data %s\r\n",(char*)message.payload);
        
        sprintf(buf, "%3.1f", temp);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("/wiznet/temperature", message);
        printf("publish temperature data %s\r\n",(char*)message.payload);
        
        client.yield(5000);
    }
}

