/*
 * Copyright (C) 2014 Wiznet, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#include "mbed.h"
#include "WizFi250Interface.h"
#include "Websocket.h"
 
#define SECURE WizFi250::SEC_AUTO
#define SSID "YOUR-SSID"
#define PASS "YOUR-PASSWORD"
 
#if defined(TARGET_LPC1768)
    #define _TXD    p28
    #define _RXD    p27
    #define _RTS    NC
    #define _CTS    NC
    #define _RESET  p21
    #define _BAUD   115200
#elif defined(TARGET_KL25Z)
    #define _TXD    PTE0
    #define _RXD    PTE1
    #define _RTS    NC
    #define _CTS    NC
    #define _RESET  PTD4
    #define _BAUD   115200
#endif

Serial pc(USBTX,USBRX);
WizFi250Interface wizfi250(_TXD,_RXD,_RTS,_CTS,_RESET,NC,_BAUD,&pc);

int main()
{
    printf("Start Application\r\n");
    
    wizfi250.init();
    while (wizfi250.connect(SECURE, SSID, PASS));
    printf("IP Address is %s\r\n", wizfi250.getIPAddress());
    
    Websocket ws("ws://sockets.mbed.org:443/ws/kaizen/wo");
    while (!ws.connect());
    
    while(1)
    {
        printf("Send:Websocket Hello World over WizFi250\r\n");
        ws.send("Websocket Hello World over WizFi250");
        wait(1.0);
    }
}