/* WiFiInterface Base Class
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef WIFI_INTERFACE_H
#define WIFI_INTERFACE_H

#include "NetworkInterface.h"

/** Enum for WiFi encryption types
 */
typedef enum wifi_security_t {
    WI_NONE = 0,    /*!< No security for connection */
    WI_WEP,         /*!< WEP  encryption */
    WI_WPA,         /*!< WPA  encryption */
    WI_WPA2,        /*!< WPA2 encryption */
} wifi_security_t;


/** WiFiInterface class
 *  Common interface that is shared between WiFi devices
 */
class WiFiInterface : public NetworkInterface
{
public:
    /** Start the interface
     *  @param ssid Name of the network to connect to
     *  @param pass Security passphrase to connect to the network
     *  @param security Type of encryption to connect with
     *  @param timeout_ms Time in milliseconds to wait for a connection
     *  @return 0 on success
     */
    virtual int32_t connect(
        const char *ssid,
        const char *pass,
        wifi_security_t security = WI_NONE,
        uint32_t timeout_ms = 15000) = 0;

    /** Stop the interface
     *  @return 0 on success
     */
    virtual int32_t disconnect() = 0;
};

#endif
