/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef SOCKET_H
#define SOCKET_H

/** Abstract socket class
  */
class Socket {
public:
    /** Socket lifetime
     */
    Socket();
    ~Socket();
    
    /** Set blocking or non-blocking mode of the socket
    \param blocking  true for blocking mode, false for non-blocking mode.
    */
    void set_blocking(bool blocking);
    
    /** Set timeout on a socket operation
    \param timeout   timeout in ms
    */
    void set_timeout(unsigned int timeout);

    /** Set socket options
    \param level     stack level
    \param optname   option ID
    \param optval    option value
    \param optlen    length of the option value
    \return 0 on success, negative on failure
    */
    int set_option(int level, int optname, const void *optval, unsigned int optlen);
    
    /** Get socket options
    \param level     stack level
    \param optname   option ID
    \param optval    buffer pointer where to write the option value
    \param socklen_t length of the option value
    \return 0 on success, negative on failure
    */
    int get_option(int level, int optname, void *optval, unsigned int *optlen);
    
    /** Close the socket
    \param shutdown  free the left-over data in message queues
    */
    int close(bool shutdown=true);
};

#endif
