/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef TCPSOCKET_H
#define TCPSOCKET_H

#include "Socket.h"

/**
TCP socket connection
*/
class TCPSocket : public Socket {
public:
    /** TCP socket lifetime
    */
    TCPSocket();
    ~TCPSocket();
    
    /** Connects this TCP socket to the server
    \param host     The host to connect to. It can either be an IP Address
                    or a hostname that will be resolved with DNS
    \param port     The host's port to connect to
    \return         0 on success, negative on failure
    */
    int connect(const char* host, const int port);
    
    /** Check if the socket is connected
    \return         true if connected, false otherwise
    */
    bool is_connected(void);
    
    /** Send data to the remote host
    \param data     The buffer to send to the host
    \param size     The length of the buffer to send
    \return         Number of written bytes on success, negative on failure
     */
    int send(const void *data, unsigned size);
    
    /** Receive data from the remote host
    \param data     The buffer in which to store the data received from the host
    \param size     The maximum length of the buffer
    \return         Number of received bytes on success, negative on failure
     */
    int receive(void *data, unsigned size);
};

#endif
