#include "mbed.h"
#include "Serial.h"

Serial usbSerial(USBTX,USBRX);
PwmOut r(p21),g(p22),b(p23);
DigitalIn switch1(p20);
DigitalOut led1(LED1);

int main(){
    //switch1.mode(PullUp);
    int red,green,blue,oldred,oldgreen,oldblue;
    int onoff = 1;
    
    r.period(0.02);
    g.period(0.02);
    b.period(0.02);
    
    led1 = 1;
    
    while(1){
         oldred = red;
         oldgreen = green;
         oldblue = blue;
         
         char c = usbSerial.scanf("%d,%d,%d", &red,&green,&blue);
         
         if((red-oldred)!=0||(green-oldgreen)!=0||(blue-oldblue)!=0){
             onoff = 1;
         }
         
         if (onoff){
             r.write(1.0f-red/255.0f);
             g.write(1.0f-green/255.0f);
             b.write(1.0f-blue/255.0f);
         }else{
             r.write(1.0f);
             g.write(1.0f);
             b.write(1.0f);
         }
         
         if(switch1 == 1){
             onoff = 0;
             led1 = 0;
         }
     }
}