// Hello World example for the USBAudio library
 
#include "mbed.h"
#include "USBAudio.h"
PwmOut led(p22);
Serial pc(USBTX, USBRX);
 
// frequency: 48 kHz
#define FREQ 48000
 
// 1 channel: mono
#define NB_CHA 1
 
// length of an audio packet: each ms, we receive 48 * 16bits ->48 * 2 bytes. as there is one channel, the length will be 48 * 2 * 1
#define AUDIO_LENGTH_PACKET FREQ/1000 * 2 * 1
 
// USBAudio
USBAudio audio(FREQ, NB_CHA);
int16_t buf[AUDIO_LENGTH_PACKET/2];
float bufo[2][AUDIO_LENGTH_PACKET/2];
bool swb=false,swb2=false;
int pli=0;
void Sample_timer_interrupt(void)
{
    //static unsigned int i=0;
 
    // send next analog sample out to D to A
    led = bufo[swb][pli];
    // increment pointer and wrap around back to 0 at 128
 pli++;
    if(pli==(AUDIO_LENGTH_PACKET>>1))pli=0,swb=!swb;
 //if(i==0)audio.read((uint8_t *)buf);
}
 
int main() {
    //int16_t buf[AUDIO_LENGTH_PACKET/2];
   //led.pulsewidth(0.000000001);
    led.period(1.0/(96000.0*2));//1.0/(48000.0*16));
    // set up a timer to be used for sample rate interrupts
    Ticker Sample_Period;
      Sample_Period.attach(&Sample_timer_interrupt, 1.0/(FREQ));
     // audio.read((uint8_t *)buf);
    while (1) {
        // read an audio packet
        audio.read((uint8_t *)buf);
        float vol=audio.getVolume();
        // print packet received
        //pc.printf("recv: ");
        //swb2=false;
        for(int i = 0; i < (AUDIO_LENGTH_PACKET>>1); i++) {
          bufo[!swb][i]=((float)buf[i]*vol/510.0)+0.5;}
          pli=0;
          //swb2=true;
          //  led = (float)buf[i]/128.0;
            //pc.printf("%d ", buf[i]);
           // led=(float)buf[i]/128.0;
       // }
       // pc.printf("\r\n");
    }
    
}