#ifndef LCD_H
#define LCD_H
#include "mbed.h"
#include <string>
#include <stdio.h>

class LCD : public Stream {
public:
    LCD(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7);
       
/*       
               *******************************
               **** DEFINIÇÕES DE ROTINAS ****
               *******************************
*/


// Função de inicialização do LCD:
    void Inicia_LCD(void);            

// Função que define se o cursor saiu do display:
    void fim_de_curso(void);

// Comando que indica para o LCD que metade dos bits foram enviados:
    void bate_enable(void);
    
// Função que escreve na CGRAM(Memória) ou na DDRAM(Tela):
    void WRI(int value);
    
// Função que manda comando para o LCD:
    void CMD(int value);
    
// Função que inicializa os caracteres definidos em si:
    void setup_chars();

/*
               *******************************
               **** DEFINIÇÕES DE FUNÇÕES ****
               *******************************
*/

// Função que retorna um array de chars contendo a posição ["(", "1", ",", "1", ")"]
    string Lepos(void);  
      
// Função que escreve na DDRAM o caracter colocado em hex
    void putc(int value);
    
// Função que limpa o display e volta o cursor para (1,1):
    void clc(void);

// Função que volta o cursor para (1,1):
    void home(void);

// Função que manda o cursor para a direita:
    void direita(void);

// Função quem manda o cursor para a esquerda:
    void esquerda(void);
    
// Função que manda o display para linha de cima:
    void cima(void);

// Função que manda o display para linha de baixo:
    void baixo(void);

// Função que apaga o que está no cursor:
    void apaga(void);

// Função que posiciona o cursor na linha e coluna inseridas:
    void pos(int linha, int coluna);
    
// Função que faz um relógio girar no LCD
    void Clock(int li, int co);    
    
/*    
               ********************************
               **** DEFINIÇÕES DE ENTRADAS ****
               ********************************
*/
    DigitalOut RS, E; // Saídas digitais de RS e Enable
    BusOut dados;     // Saídas digitais de comunicação com o display
    
/*    
               ********************************
               **** DEFINIÇÃO DE VARIÁVEIS ****
               ********************************
*/
               
    int _coluna;        // Posição do cursor em relação a coluna
    int _linha;         // Posição do cursor em relação a linha
    char _chars[2][16]; // Array que guarda o que tá escrito no display
    
    
// Stream implementation functions
    virtual int _putc(int value);
    virtual int _getc();
};
  
#endif
