#include "LCD_ka.h"
/*
               ***********************
               **** INICIALIZAÇÃO ****
               ***********************
*/               
LCD::LCD(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7) : RS(rs), E(e), dados(d4,d5,d6,d7){
    Inicia_LCD();
    setup_chars();
    this ->_coluna = 1;
    this ->_linha = 1;
}

               
/*
                ********************
                **** INICIA_LCD ****
                ********************
*/
void LCD::Inicia_LCD(void){
    RS = 0;
    E = 0;
    dados = 0x0;
    wait(0.05);
    for (int i=0; i<3; i++){
        CMD(0x20);  // Define como 4 bits

        CMD(0x28);  // Define 0 0 1 DL - N F _ _ 
                    //(DL = Data Lengh: 0 --> 4 Bits
                    //                  1 --> 8 Bits)
                    //(N = n° de linhas:0 --> 1 linha
                    //                  1 --> 2 linhas)
                    //(F = n° de pontos:0 --> 5 x 8 pontos
                    //                  1 --> 5 x 10 pontos)
        
        
        CMD(0x0E);  // Define 0 0 0 0 - 1 D C B 
                    //(D = Display on/off: 0 --> off
                    //                     1 --> on)
                    //(C = Cursor on/off : 0 --> off
                    //                     1 --> on)
                    //(B = Blink on/off  : 0 --> off
                    //                     1 --> on)
        
        
        CMD(0x06);  // Define 0 0 0 0 - 0 1 I/D S
                    //(I/D = Direção de escrita: 0 --> Direita
                    //                           1 --> Esquerda)
                    //(S = Display shift :       0 --> Não
                    //                           1 --> Sim)
        }
        clc();      // Limpa o diplay
}
               
/*               
               **********************
               **** FIM DE CURSO ****
               **********************
*/
void LCD::fim_de_curso (void){
    switch (_coluna){
        case 17 :                          // Se a coluna for igual a 17
            switch (_linha){               // o cursor vai para:
                case 1 : pos(2,1); break;  // Linha debaixo 
                case 2 : home(); break;    // Posição (1,1)
            }
        break;
        
        case 0 :                           // Se a coluna for igual a 0
            switch (_linha){               // o cursor vai para:
                case 1 : pos(2,16); break; // Linha debaixo
                case 2 : pos(1,16); break; // Linha de cima
            }
        break;
    }
}

/*
               *********************
               **** BATE ENABLE ****
               *********************
*/
void LCD::bate_enable(void){
    E = 1;
    wait(0.000040f);
    E=0;
    wait(0.000040f);
}

/*
               *************
               **** WRI ****
               *************
*/
void LCD::WRI(int value){
    RS = 1;
    dados = value>>4;
    bate_enable();
    dados = value;
    bate_enable();
}
               
/*
               *************
               **** CMD ****
               *************
*/
void LCD::CMD(int value){
    RS = 0;
    dados = value>>4;
    bate_enable();
    dados = value;
    bate_enable();
}
               
/*
               *********************
               **** SETUP_CHARS ****
               *********************
*/
void LCD::setup_chars(){
    int new_chars[] = {0x00, 0x01, 0x03, 0x16, 0x1c, 0x08, 0x00, 0x00, // Correto                       (0)
                       0x00, 0x0A, 0x0A, 0x0A, 0x00, 0x11, 0x0E, 0x00, // Sorriso                       (1)
                       0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, // Relógio                       (2)
                       0x00, 0x04, 0x0E, 0x15, 0x04, 0x04, 0x00, 0x00, // Seta para cima                (3)
                       0x00, 0x00, 0x04, 0x04, 0x15, 0x0E, 0x04, 0x00, // Seta para baixo               (4)
                       0x0e, 0x11, 0x05, 0x09, 0x1e, 0x08, 0x04, 0x00, // Seta Horário                  (5)
                       0x0e, 0x11, 0x14, 0x12, 0x0f, 0x02, 0x04, 0x00, // Seta Anti_horário             (6)
                       0x00, 0x04, 0x08, 0x17, 0x08, 0x04, 0x00, 0x00, // Seta para Esquerda            (7)
                       0x00, 0x04, 0x02, 0x1d, 0x02, 0x04, 0x00, 0x00  // Seta para Direita             (8)
                       };

    CMD(0x40);
    for (int i = 0; i < 7*8; i++){
        WRI(new_chars[i]);
    }
    CMD(0x80);

}




/*
               **********************
               ***** FUNÇÃO CLC *****
               **********************
*/

void LCD::clc(void){
    CMD(0x01);
    wait(0.002);
    _coluna = 1;
    _linha = 1;
}


/*
               ***********************
               ***** FUNÇÃO HOME *****
               ***********************
*/
void LCD::home(void){
    wait(0.002);
    
    dados = 0x0;
    bate_enable();
    dados = 0x2;
    bate_enable();
    
    wait(0.002);
    
    _coluna = 1;
    _linha = 1;
}


/*
               **************************
               ***** FUNÇÃO DIREITA *****
               **************************
*/

void LCD::direita(void){
    wait(0.0002);
    
    dados = 0x1;
    bate_enable();
    dados = 0x4;
    bate_enable();
    
    wait(0.0002);
    
    _coluna = _coluna+1;
    
    fim_de_curso(); 
    wait(0.2);
}


/*
               ***************************
               ***** FUNÇÃO ESQUERDA *****
               ***************************
*/

void LCD::esquerda(void){
    wait(0.0002);
    
    dados = 0x1;
    bate_enable();
    dados = 0x0;
    bate_enable();
    
    wait(0.0002);
    
    _coluna = _coluna - 1;
    
    fim_de_curso();
    wait(0.2);
}


/*
               ************************
               ***** FUNÇÃO APAGA *****
               ************************
*/

void LCD::apaga(void){
    RS = 1;
    
    wait(0.002);
    
    dados = 0x2;
    bate_enable();
    dados = 0x0;
    bate_enable();
    
    RS = 0;
    
    pos(_linha,_coluna);
}


/*
               ***********************
               ***** FUNÇÃO CIMA *****
               ***********************
*/

void LCD::cima(void){
    pos(1,_coluna);
    wait(0.2);
    _linha = 1;
}


/*
               ************************
               ***** FUNÇÃO BAIXO *****
               ************************
*/

void LCD::baixo(void){
    pos(2,_coluna);
    wait(0.2);
    _linha = 2;
}


//

/*
               **********************
               ***** FUNÇÃO POS *****
               **********************
*/
void LCD::pos(int li, int co){
    int POSI = 0x80 + ((li-1) * 0x40) + (co-1);
    
    CMD(POSI);
    
    _coluna = co;
    _linha = li;
}   




/*
               ***********************
               ***** FUNÇÃO PUTC *****
               ***********************
*/


 
int LCD::_putc(int value) {
    if (value == '\n') {
        baixo();
    }
    if(value == '~'){
        WRI(0x00);
        WRI(0x01);
        WRI(0x02);
        WRI(0x03);
        WRI(0x04);
    }
    else{
        RS = 1;
        dados = value>>4;
        bate_enable();
        dados = value;
        bate_enable();
        RS = 0;
    }
    _chars[_linha-1][_coluna-1] = value;
    _coluna++;
    fim_de_curso();
    
    return value;
}

int LCD::_getc() {
    return -1;
}


void LCD::putc(int value){
    RS = 1;
    dados = value>>4;
    bate_enable();
    dados = value;
    bate_enable();
    _coluna++;
    fim_de_curso();
}



void LCD::Clock(int li, int co){
    int relogio[8][8] = {0x00,0x0e,0x15,0x17,0x11,0x0e,0x00,0x00, 
                         0x00,0x0e,0x15,0x15,0x13,0x0e,0x00,0x00, 
                         0x00,0x0e,0x15,0x15,0x15,0x0e,0x00,0x00,
                         0x00,0x0e,0x15,0x15,0x19,0x0e,0x00,0x00,
                         0x00,0x0e,0x15,0x1d,0x11,0x0e,0x00,0x00,
                         0x00,0x0e,0x1d,0x15,0x11,0x0e,0x00,0x00,
                         0x00,0x0e,0x15,0x15,0x11,0x0e,0x00,0x00,
                         0x00,0x0e,0x17,0x15,0x11,0x0e,0x00,0x00
                         }; 
    
    for (int i = 0; i < 8; i++){
        CMD(0x40);
        for (int j = 0; j < 8; j++){
            WRI(relogio[i][j]);
        }
        pos(li,co);
        wait(1);
        WRI(0x00);
        
    }
    

}


/*
               ************************
               ***** FUNÇÃO LEPOS *****
               ************************
*/


string LCD::Lepos(void){
    string buffer;
    char li[6];
    sprintf(li,"(%d,%d)", _linha, _coluna);
    buffer.append(li);
    return buffer;
    
}

    