#include "mbed.h"

PwmOut IN1 (PA_8);
PwmOut IN2 (PA_9);
PwmOut IN3 (PA_10);
Serial pc(USBTX, USBRX);
InterruptIn Bot(PC_13);
DigitalOut EN1 (PC_10);
DigitalOut EN2 (PC_11);
DigitalOut EN3 (PC_12);
AnalogIn Potenciometro(PB_1);

bool Acionar = true;
float Tim;
float POT;


void Ativacao(){
    if (Acionar == true){
        EN1 = 0;
        EN2 = 0; 
        EN3 = 0;
        Acionar = false;
        }
        
    else {
        Acionar = true;
    }
}


int main()
{
    pc.baud(9600);
    EN1 = 0;
    EN2 = 0; 
    EN3 = 0;
    
    Acionar = false;
    
    IN1.period_ms(1);
    IN2.period_ms(1);
    IN3.period_ms(1);
    
    IN1.write(0);
    IN2.write(0);
    IN3.write(0);
    
    Bot.fall(&Ativacao);
    
   while(1){
        pc.printf("%f : %f\n\r", Tim, POT);
        POT = Potenciometro.read()*1000;
        Tim = (POT/1000)*(10-2)+2;      // Criação de uma conversão POT para Tim
    while (Acionar == true){  
        Tim = (Potenciometro.read()*8+2)/1000; 
        //Step 1
        IN1.write(0);
        IN2.write(0.9);
        IN3.write(0);
        EN1 = 0;
        EN2 = 1;
        EN3 = 2;
        wait(Tim);    
    
        //Step 2
        IN1.write(0);
        IN2.write(0.9);
        IN3.write(0);
        EN1 = 2;
        EN2 = 1;
        EN3 = 0;
        wait(Tim);
    
    
        //Step 3
        IN1.write(0);
        IN2.write(0);
        IN3.write(0.9);
        EN1 = 2;
        EN2 = 0;
        EN3 = 1;
        wait(Tim);
    
    
        //Step 4
        IN1.write(0);
        IN2.write(0);
        IN3.write(0.9);
        EN1 = 0;
        EN2 = 2;
        EN3 = 1;
        wait(Tim);
    
    
        //Step 5
        IN1.write(0.9);
        IN2.write(0);
        IN3.write(0);
        EN1 = 1;
        EN2 = 2;
        EN3 = 0;
        wait(Tim);    
    
    
        //Step 6
        IN1.write(0.9);
        IN2.write(0);
        IN3.write(0);
        EN1 = 1;
        EN2 = 0;
        EN3 = 2;
        wait(Tim);
    } 
  }     
} 