#include "mbed.h"

SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);

Serial pc(USBTX, USBRX); // tx, rx

// Write configuration.  CFG is assumed to be a 6 byte array
void write_cfg(int * cfg) {
    // Chip enable
    cs = 0;
    // Send 0x01 for Writing Configuration Register Group
    spi.write(0x01);
    int i;
    // Send 6 bytes of cfg
    for (i=0; i<6; i++)
        spi.write(cfg[i]);
    // Done sending
    cs = 1;
}

// Read configuration. cfg is assumed to be a 7 int buffer
void read_cfg(int * cfg) {
    cs = 0;
    // Select the first board
    spi.write(0x80);
    // Read config
    spi.write(0x02);
    int i;
    for (i=0; i<7; i++)
        cfg[i] = spi.write(0xAA);
    cs = 1;
}

void start_ADC() {
    cs = 0;
    spi.write(0x10);
    cs = 1;
}

// buf is a 19 int array
void read_batt(int * buf) {
    cs = 0;
    spi.write(0x80);
    spi.write(0x04);
    int i;
    for (i=0; i<19; i++) {
        buf[i] = spi.write(0xAA);
    }
    cs = 1;
}

// buf is a 19 int array, out is a 12 int array
void conv_batt(int * buf, int * out) {
    out[0] = (buf[0] & 0xFF) | (buf[1] & 0x0F) << 8;
    out[1] = ((buf[1] & 0xF0) >> 4) | ((buf[2] & 0xFF) << 4);
    
    out[2] = (buf[3] & 0xFF) | (buf[4] & 0x0F) << 8;
    out[3] = (buf[4] & 0xF0) >> 4 | (buf[5] & 0xFF) << 4;
    out[4] = (buf[6] & 0xFF) | (buf[7] & 0x0F) << 8;
    out[5] = (buf[7] & 0xF0) >> 4| (buf[8] & 0xFF) << 4;
    out[6] = (buf[9] & 0xFF) | (buf[10] & 0x0F) << 8;
    out[7] = (buf[10] & 0xF0) >> 4| (buf[12] & 0xFF) << 4;
    out[8] = (buf[12] & 0xFF) | (buf[13] & 0x0F) << 8;
    out[9] = (buf[13] & 0xF0) >> 4| (buf[14] & 0xFF) << 4;
    out[10] = (buf[15] & 0xFF) | (buf[16] & 0x0F) << 8;
    out[11] = (buf[16] & 0xF0) >> 4| (buf[17] & 0xFF) << 4;
}

int main() {
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 0.5MHz clock rate
    spi.format(8,0);
    spi.frequency(100000);
    int cfg[6] = { 0xE7, 0x00, 0x00, 0x00, 0x00, 0xFA };
    write_cfg(cfg);
    wait(0.2);
    while(1) {
        int buf[19];
        int i;
        start_ADC();
        wait(0.1);
        read_batt(buf);
        int batt[12];
        conv_batt(buf, batt);
        for (i=0;i<12;i++)
            pc.printf("%d: %f \r\n", i, batt[i] * 1.5 / 1000);
        pc.printf("\r\n=============================\r\n");
        wait(2);
    }
}