// Display Test
//#include "mbed.h"
#include "KS0108.h"
#include "calsolimage.h"
#include "numbers.h"
#include "Arial12.h"
#include "Arial14.h"
#include "arial_bold_14.h"
#include "ArialB40.h"
#include "SystemFont5x7.h"
#include "HelveticaB35.h"
#include "CourierNew_B70.h"

// Declare each of the things you're going to use
// The display
KS0108 display(p23,p21,p22,p20,p24,p25,p17,p18,p19,p30,p29,p28,p27,p26);
// The button on the breadboard
DigitalIn topButton(p13);
// For printing things to the computer
Serial pc(USBTX,USBRX);
// Timers
Timer timer1;
Timer timer2;
Timer testTimer;

// Declare methods, the actual body is down there.
// You have to do this for C
void rules (unsigned char *);
void random (unsigned char *);

// This is where your programs starts running
int main() {
  // Initialize variables
  int dist = 20;
  int demo = 0;
  int i = 0;
  topButton.mode(PullUp);
  // Display CalSol logo
  display.FullScreenBMP(pic);
  wait(0.2);

  timer1.start();  // For button stuff
  timer2.start();
  
  int percentage = 0; //integer value from 0 to 100 (battery)
  int speed = 150;          //integer value from 0 to 999
  double current = 15.2;    //double  value from 0 to 99.9
  
  while(1) {
    if(!topButton) {
      if(timer1.read_ms() > 200) {
        demo++;
        display.ClearScreen();
        if(demo > 3) {
          demo = 0;
        }
        timer1.reset();
      }
    }
    switch(demo) {
    case 0:
      if(timer2.read_ms() > 500) {
        rules(pic);
        display.FullScreenBMP(pic);
        timer2.reset();
      }
      break;
      
    case 1:
   
    //GRID:
        //speed:   70x64, ( 0,  0)
        //current: 57x23, (71,  0)
        //battery: 57x40, (71, 23)
    display.HLineShort(71, 64-24, 57, BLACK);
    display.VLineShort(71, 0, 64, BLACK);
 
 
 /*
    /*
     //CURRENT
     display.SelectFont(Arial_Bold_14, WHITE, ReadData);
     display.GotoXY(78, 8);
     display.PrintNumber(current); // this doesn't work with doubles
     display.SelectFont(System5x7, WHITE, ReadData);
     display.GotoXY(110, 8);
     display.PrintString("Amp");
     */
     
    
    //BATTERY
    display.RoundRectangle(82, 2, 40, 24, 4, BLACK); //body: 40x24
    display.EmptyRectangle(78, 10, 78+4, 10+8, BLACK);//head:  4x8
    display.SelectFont(System5x7, WHITE, ReadData);
    display.GotoXY(108, 24+8);
    display.PrintString("%");   
    
    
    //PERCENTAGE (reasonable update rate: testTimer.read_ms()/700)
    /*
    int INITIAL_PERCENTAGE = 100;
    int percentage = INITIAL_PERCENTAGE; // values 0-100
    int newPercentage = percentage; // values 0-100
    int barPosition = 86+(int)(((double)(100-percentage)/100.0)*32);
    int newBarPosition = 86+(int)(((double)(100-newPercentage)/100.0)*32); //x-coordinates
    
    display.SelectFont(System5x7, BLACK, ReadData);
    
    //draw initial box
    display.FullRectangle(barPosition, 2+4, 86+32, 2+24-4, BLACK); //inside: 32x16
    int y = 32; //y coordinate for percenage. for testing/fixing font
    
    testTimer.start();
   
    while (newPercentage <= 100 && newPercentage >= 0) //testing update rate/centering
    {
        if (testTimer.read_ms()%700 == 0)
        {
            //account for number of digits
            
            if (newPercentage > 99)
                display.GotoXY(88, y);
            else if (newPercentage >= 10)
            {
                if (percentage > 99)
                    display.FullRectangle(88, y, 88+5, y+7, WHITE);
                display.GotoXY(94, y);
            }
            else
            {
                if (percentage >= 10)
                    display.FullRectangle(88, y, 88+5*2+1, y+7, WHITE);
                display.GotoXY(100,y);
            }
            
            
            display.PrintNumber(newPercentage);
            
            
            
            barPosition = 86+(int)(((double)(100-percentage)/100.0)*32);
            newBarPosition = 86+(int)(((double)(100-newPercentage)/100.0)*32);
            
            //draw increase or decrease in percentage
            if (newBarPosition < barPosition) //percentage increase
                display.FullRectangle(newBarPosition, 2+4, barPosition, 2+24-4, BLACK);
            else if (newBarPosition > barPosition) //percentage decrease
                display.FullRectangle(barPosition, 2+4, newBarPosition, 2+24-4, WHITE);
                
                
            //update percentages
            percentage = newPercentage;
            //newPercentage = testTimer.read_ms()/700; //slow increase
            newPercentage = INITIAL_PERCENTAGE-(testTimer.read_ms()/700); //rapid decrease
            
        }
   }*/
   
   //SPEED
   
   display.SelectFont(System5x7, WHITE, ReadData);
   display.GotoXY(26, 48);
   display.PrintString("MPH");
   testTimer.start();
     
    display.SelectFont(CourierNew_B70, WHITE, ReadData); 
    /* while (true){
         if (testTimer.read_ms()%700 == 1)
         {*/  // for testing
             //speed = testTimer.read_ms()/1000;
             speed += (int)((rand()%3)-2);
             
             //display.FullRectangle(0, 16, 70, 44, WHITE); //clears space too slowly. find alternative
             
             if (speed > 99)       // 3digits
                display.GotoXY(1, 16);
             else if (speed >= 10) // 2digits
                display.GotoXY(3+10, 16);
             else                  //1digit
                display.GotoXY(3+10*2, 16);
             
             display.PrintNumber(speed); 
         /*}
     }*/
   */
      break;
    case 2:
      // This block does the bar graph stuff.
      if(timer2.read_ms() > 100) {
        // display.PutString(3,2,"I can has mbed too");
       //  display.PrintFloat(123.23,4,5);
         display.VLine(6+i,47,56,BLACK);
         if (i < 10){dist = 30;}
         else if (i < 100){dist = 25;}
         else {dist = 20;}         
         display.PrintInteger(i,6,dist);
         i++;
         if(i > 100) {
           i = 0;
           display.ClearScreen();
         }
         timer2.reset();
      }
      break;
    case 3:
      if(timer2.read_ms() > 500) {
        rules(pic);
        display.FullScreenBMP(pic);
        timer2.reset();
      }
      default:
      break;
    }
  }
}

//For Conway's Game of Life
void rules (unsigned char * array) {
  char neighborArray[128][64];
  // Get number of neighbors
  for (int x = 0; x < 128; x++) {
    for (int y = 0;y < 64; y++) {
      neighborArray[x][y] = 0;
    }
  }
  for (int y = 0;y < 64; y++) {
    for (int x = 0; x < 128; x++) {
      if (array[x + (y/8*8)*16] & (1<<(y%8))) {
        if (x != 0) {
          neighborArray[x-1][y] += 1;
          if (y != 0) {
            neighborArray[x-1][y-1] += 1;
          }
          if (y != 127) {
            neighborArray[x-1][y+1] += 1;
          }
        }
        if (x != 127) {
          neighborArray[x+1][y] += 1;
          if (y != 0) {
            neighborArray[x+1][y-1] += 1;
          }
          if (y != 127) {
            neighborArray[x+1][y+1] += 1;
          }
        }
        if (y != 0) {
          neighborArray[x][y-1] += 1;
        }
        if (y != 63){
          neighborArray[x][y+1] += 1;
        }
      }
    }
  }
  int arrayIndex;
  for (int y = 0;y < 64; y++) {
    for (int x = 0; x < 128; x++) {
      arrayIndex = x + (y/8*8)*16;
      if (neighborArray[x][y] == 3) {
        array[arrayIndex] |= (1<<(y%8));
      } else if (neighborArray[x][y] == 2) {
        continue;
      } else {
        array[arrayIndex] &= ~(1<<(y%8));
      }
    }
  }
}

//Is this used anywhere?
void random (unsigned char * array) {
  for (int y = 0;y < 64; y += 8) {
    for (int x = 0; x < 128; x++) {
      array[x + y*16] = (unsigned char) rand();
    }
  }
}