/*
 * UDENOKAI #5 SAMPLE PROGRAM: Tweeting with mbed!
 * 
 * Using SuperTweet.Net API Proxy (setup required).
 * Based on cookbook/Twitter
 */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NTPClient.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX); // tx, rx
TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7
EthernetNetIf eth;
NTPClient ntp;

int main() {
  
  // Tweet informations
  char message[64], name[32], twID[32], twPW[32];
  sprintf(message, "hogehogefugafuga");
  sprintf(name, "hoge");     // ex) @kagamikan
  sprintf(twID, "fuga");     // ex) udenokai
  sprintf(twPW, "piyo");     // ex) hoge

  // Setup IP Network
  pc.printf("\r\nSetting up...\r\n");
  lcd.printf("Setting up...");
  EthernetErr ethErr = eth.setup();
  if(ethErr) {
    printf("Error %d in setup.\n", ethErr);
    lcd.printf("\nError %d in setup.", ethErr);
    return -1;
  }
  IpAddr ip = eth.getIp();
  pc.printf("\r\nSetup OK\r\n");
  lcd.cls();
  lcd.printf("IP Address:\n%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);
  
  // Setting time with NTP
  Host server(IpAddr(), 123, "ntp.nict.jp");
  ntp.setTime(server);
  time_t ctTime;
  ctTime = time(NULL);
  ctTime += 32400; //set jst time
  
  // Building the tweet
  char tweet[128], ts[32];
  strftime(ts, 32, "%I:%M %p\n", localtime(&ctTime));
  sprintf(tweet, "%s (%s's mbed at %s JST) #udenokai", message, name, ts);
  pc.printf(tweet);

  // Sending the tweet
  HTTPClient twitter;
  HTTPMap msg;
  msg["status"] = tweet;
  twitter.basicAuth(twID, twPW);
  HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
  if(r == HTTP_OK) {
    pc.printf("Tweet success!\n");
    lcd.cls();
    lcd.printf("\nTweet success!");
  } else {
    pc.printf("Tweet failed (Code:%d)\n", r);
    lcd.cls();
    lcd.printf("\nTweet failed (%d)", r);
  }
  
  return 0;
}