#include "mbed.h"
//#define BUTTON1 A1
//#define BUTTON1 p14
BusOut myleds(LED1,LED2,LED3,LED4);
DigitalIn button(BUTTON1);

void nibbleLeds(int value);
void printb(uint8_t x);
int modifyBit(int x, uint8_t position, bool State);
int lauflicht(bool richtung, int time, int &anz);
const int INIT = 0x03;


int main() {
    int anzahl, anz;
    uint8_t value = INIT;
    anzahl = lauflicht(true, 400, anz = 0);
    
    printf("anzahl = %d\n", anzahl);
    nibbleLeds(value);
    printb(myleds);
    value = modifyBit(value, 2, 1);
    printb(myleds);
    printb(modifyBit(value, 3, 1));
    wait(0.1);
}

void nibbleLeds(int value) {
    myleds = value % 16;
}

void printb(uint8_t x){
    for(int i = sizeof(x) << 3; i; i--)
        putchar('0' + ((x >> (i - 1)) & 1));
    printf("\n");
}

int modifyBit(int x, uint8_t position, bool State){
    int mask = 1 << position;
    int state = int(State);
    return (x & ~mask) | ((state << position) & mask);
}

int lauflicht(bool richtung, int time, int &anz){
    int i;
    uint8_t lauf = 0x01;
    
    if(!richtung)
        lauf = 0x08;
    while(1) {
        nibbleLeds(lauf & 0x0f);
        if(richtung){
            lauf = lauf << 1;
            if (lauf > 8)
                lauf = 0x01;
        }
        else {
            lauf = lauf >> 1;
            if (lauf == 0)
                lauf = 0x08;
        }
        if (button)
            break;
        wait_ms(time);
        anz++;
    }
    return anz;
}