/*
 * Copyright (c) 2018, ARM Limited, All Rights Reserved
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * \file nfc_common.h
 * \copyright Copyright (c) ARM Ltd 2018
 * \author Donatien Garnier
 * \details Common includes for NFC Stack
 */

#ifndef NFC_COMMON_H_
#define NFC_COMMON_H_

#include "stddef.h"
#include "stdint.h"
#include "string.h"
#include "stdbool.h"

#include "nfc_errors.h"

#include "platform/nfc_debug.h"

#include "acore/ac_macros.h"
#include "acore/ac_buffer.h"
#include "acore/ac_buffer_reader.h"
#include "acore/ac_buffer_builder.h"
#include "acore/ac_stream.h"

#endif /* NFC_COMMON_H_ */

/**
 * @}
 * @}
 * */
