#include "LedLcd.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;


LedLcd::LedLcd(uint8_t iColumnNumberConstructor){
    iColumnNumber = iColumnNumberConstructor;
    LcdInit();
}


void LedLcd::DrawKey(uint16_t iXPosKey, uint16_t iyPosKey, uint8_t iKeyNumber, uint32_t iColor){
    uint8_t iKeyNumberArray[1];
    lcd.SetFont(&Font24);
    lcd.SetTextColor(iColor);
    lcd.FillRect(iXPosKey, iyPosKey, 80, 80);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(iXPosKey, iyPosKey, 80, 80);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    sprintf((char*)iKeyNumberArray, "%d", iKeyNumber);
    lcd.DisplayStringAt(iXPosKey, iyPosKey, (uint8_t *) &iKeyNumberArray , LEFT_MODE);

        
}
    
void LedLcd::On(uint8_t iKeyIndex){
    uint8_t iKeyCounter;

    for(iKeyCounter = 0; iKeyCounter <= 3; iKeyCounter++){
       if(iKeyIndex == iKeyCounter){
            DrawKey(iColumnNumber*80, iKeyCounter*80, iKeyCounter, LCD_COLOR_GREEN); 
       }
       else{
            DrawKey(iColumnNumber*80, iKeyCounter*80 , iKeyCounter, LCD_COLOR_BLUE);
       }
    }        
}
/*
void LedLcd::TouchScreenInit(){
    uint8_t status;
    BSP_LCD_SetFont(&Font20);
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
  
    if (status != TS_OK)
    {
      lcd.Clear(LCD_COLOR_RED);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    }
    else
    {
      lcd.Clear(LCD_COLOR_GREEN);
      lcd.SetBackColor(LCD_COLOR_GREEN);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }
}
*/

void LedLcd::LcdInit(void){
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
}



