#include "serial_connected_mcu_slave.hpp"

namespace serial_connected_mcu{
    serial_connected_mcu_slave::serial_connected_mcu_slave(){
        port = new Serial(PIN_SERIAL_TX, PIN_SERIAL_RX);
        port->baud(BAUDRATE);
        array_of_read_data = new int16_t[SIZE_OF_READ_DATA];
        array_of_write_data = new int16_t[SIZE_OF_WRITE_DATA];
        is_locking = false;
        received_buffer.clear();
        
        port->attach(this, &serial_connected_mcu_slave::on_received, Serial::RxIrq);
    }
    
    serial_connected_mcu_slave::~serial_connected_mcu_slave(){
        delete (port);
    }
    
    void serial_connected_mcu_slave::set(int index_of_data, int16_t setting_data){
        while (is_locking);
        is_locking = true;
        array_of_write_data[index_of_data] = setting_data;
        is_locking = false;
    }
    
    int16_t serial_connected_mcu_slave::get(int index_of_data){
        return (array_of_read_data[index_of_data]);
    }
    
    void serial_connected_mcu_slave::on_received(){
        char received_char = port->getc();
        if (received_char == '\n'){
            //port->printf("%d,%d,%d,%d,%d,%d\n", array_of_write_data[0], array_of_write_data[1], array_of_write_data[2], array_of_write_data[3], array_of_write_data[4], array_of_write_data[5]);
            for (int i = 0;;i++){
                port->printf("%d", array_of_write_data[i]);
                if (i == (SIZE_OF_WRITE_DATA - 1)){
                    break;
                }
                port->printf(",");
            }
            port->printf("\n");
            string_to_int();
            received_buffer.clear();
            return;
        }
        received_buffer.push_back(received_char);
    }
    
    void serial_connected_mcu_slave::string_to_int(){
        std::string s;
        int i = 0;
        
        while (is_locking);
        is_locking = true;
        s.clear();
        
        for (int index = 0; index < received_buffer.size(); index++){
            char c = received_buffer[index];
            if (c == ','){
                array_of_read_data[i] = atoi(s.c_str());
                i++;
                s.clear();
            }
            else {
                s.push_back(c);
            }
        }
        array_of_read_data[i] = atoi(s.c_str());
        is_locking = false;
    }

}