#ifndef SERIAL_CONNECTED_MCU_SLAVE_
#define SERIAL_CONNECTED_MCU_SLAVE_

#include "mbed.h"
#include <stdint.h>
#include <string>
#include <stdlib.h>
#include <sstream>

namespace serial_connected_mcu{
    enum read_id {
       ESC1,
       ESC2,
       ESC3,
       SIZE_OF_READ_DATA
    };
    
    enum write_id {
        ENCODER1,
        ENCODER2,
        ENCODER3,
        POTENTIONMETER1,
        POTENTIONMETER2,
        POTENTIONMETER3,
        SIZE_OF_WRITE_DATA
    };

    class serial_connected_mcu_slave{
    public:
        serial_connected_mcu_slave();
        ~serial_connected_mcu_slave();
        void set(int index_of_data, int16_t setting_data);
        int16_t get(int index_of_data);
    private:
        static const PinName PIN_SERIAL_TX;
        static const PinName PIN_SERIAL_RX;
        static const int BAUDRATE = 9600;
        int16_t* array_of_read_data;
        int16_t* array_of_write_data;
        std::string received_buffer;
        Serial* port;
        bool is_locking;
        void on_received();
        void string_to_int();
    };
}

#endif