#include "serial_connected_mcu.hpp"
#include "serial_connected_mcu_slave.hpp"
#include "mbed.h"

namespace serial_connected_mcu {
    
serial_connected_mcu* serial_connected_mcu::_instance = NULL;
const PinName serial_connected_mcu::_servo_pins[SERVO_NUM] = {
    PB_6,
    PB_7,
    PB_8
};

TIM_TypeDef* serial_connected_mcu::_encoder_timers[ENCODER_NUM] = {
    TIM1,
    TIM2,
    TIM3
};

const size_t serial_connected_mcu::_encoder_pulse_per_revol = 100;

const PinName serial_connected_mcu::_analog_input_pins[ANALOG_INPUT_NUM] = {
    A3,
    A4,
    A5
};


serial_connected_mcu* serial_connected_mcu::instance() {
    if (_instance == NULL) {
        _instance = new serial_connected_mcu;
    }
    return _instance;
}

serial_connected_mcu::serial_connected_mcu() {
    /*
    for (size_t i = 0; i < serial_connected_mcu::serial_connected_mcu_slave::) {
        _slave.set();
    }
    */
    
    for (size_t i = 0; i < SERVO_NUM; ++i) {
        _servos[i] = new servo(_servo_pins[i]);
    }
    for (size_t i = 0; i < ENCODER_NUM; ++i) {
        _encoders[i] = new rotary_encoder_ab_phase(_encoder_timers[i], _encoder_pulse_per_revol);
    }
    for (size_t i = 0; i < SERVO_NUM; ++i) {
        _analog_inputs[i] = new AnalogIn(_analog_input_pins[i]);
    }
}

serial_connected_mcu::~serial_connected_mcu() {
    for (size_t i = 0; i < SERVO_NUM; ++i) {
        delete _servos[i];
    }
    for (size_t i = 0; i < ENCODER_NUM; ++i) {
        delete _encoders[i];
    }
    for (size_t i = 0; i < SERVO_NUM; ++i) {
        delete _analog_inputs[i];
    }
}

void serial_connected_mcu::update() {
    
}

} /* namespace serial_connected_mcu */
