#ifndef INCUDED_SERIAL_CONNECTED_MCU_HPP
#define INCUDED_SERIAL_CONNECTED_MCU_HPP

#include "rotary_encoder_ab_phase.hpp"
#include "servo.hpp"
#include "serial_connected_mcu_slave.hpp"
#include "mbed.h"

namespace serial_connected_mcu {

class serial_connected_mcu {
public:
    enum servo_id {
        SERVO_0,
        SERVO_1,
        SERVO_2,
        SERVO_NUM
    };
    
    enum encoder_id {
        ENCODER_0,
        ENCODER_1,
        ENCODER_2,
        ENCODER_NUM
    };
    
    enum analog_input_id {
        ANALOG_IN_0,
        ANALOG_IN_1,
        ANALOG_IN_2,
        ANALOG_INPUT_NUM
    };

    static serial_connected_mcu* instance();
    void update();

private:
    serial_connected_mcu();
    ~serial_connected_mcu();
    
    // 実体を記述しない
    void operator=(const serial_connected_mcu&);
    serial_connected_mcu(const serial_connected_mcu&);
    
    static serial_connected_mcu* _instance;
    
    static const PinName _servo_pins[SERVO_NUM];
    
    static TIM_TypeDef* _encoder_timers[ENCODER_NUM];
    static const size_t _encoder_pulse_per_revol;
    
    static const PinName _analog_input_pins[ANALOG_INPUT_NUM];
    
    servo* _servos[SERVO_NUM];
    rotary_encoder_ab_phase* _encoders[ENCODER_NUM];
    AnalogIn* _analog_inputs[ANALOG_INPUT_NUM];
    
    serial_connected_mcu_slave _slave;
};

} /* namespace serial_connected_mcu */

#endif
