/*
  Update: 21-06-2010
  The basic authentication service for twitter is going down at the end of the week.
  To continue using that program, the code has been updated to use http://supertweet.net which acts as an API proxy.
  Simply visit the website to setup your twitter account for this API.
  See: http://www.supertweet.net/about/documentation
*/

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

EthernetNetIf eth; 

int main() {

  printf("Init\n");

  printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");

  HTTPClient twitter;
  
  HTTPMap msg;
  //msg["status"] = "I am tweeting from my mbed!"; //A good example of Key/Value pair use with Web APIs
  LocalFileSystem local("local");
  char   s[256];
  FILE   *fp;
  
  printf("\r\nreading a message file.\r\n");
  
  if(NULL == (fp = fopen("/local/tweet.txt","r")) ) {
    printf("\r\nError: The message file cannot be accessed\r\n");
    return -1;
  }
  
  fgets(s,256,fp);
  fclose(fp);
  
  msg["status"] = s;

  twitter.basicAuth("user", "pass"); //We use basic authentication, replace with you account's parameters
  
  //No need to retieve data sent back by the server
  HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
  if( r == HTTP_OK )
  {
    printf("Tweet sent with success!\n");
  }
  else
  {
    printf("Problem during tweeting, return code %d\n", r);
  }
  
  return 0;

}
