#include "mbed.h"
#include "ST7735_TFT.h"
#include "WiiChuck.h"
/*
2013.Aug.27
Wiichuck is NOT compatible with latest mbed library
it is ok with revision 39 or older
*/
WiiChuck WiiNun(p9, p10);
ST7735_TFT TFT(p11, NC, p13, p14, p12, p23,"TFT"); // mosi, (miso,) sclk, cs, rs, reset
Serial pc(USBTX,USBRX);

int main()
{

    int joyX = 0;
    int joyY = 0;
    int accX = 0;
    int accY = 0;
    int accZ = 0;
    int buttonC = 0;
    int buttonZ = 0;

    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.set_orientation(3);
    TFT.cls();                // clear the screen
//     TFT.set_font((unsigned char*) Arial12x12);  // select the font

//     TFT.set_orientation(0);
    //TFT.locate(0,0);
    //TFT.fillrect(10,100,12,150,White);
    while(1) {
        bool read = WiiNun.Read(&joyX,&joyY,&accX,&accY,&accZ,&buttonC,&buttonZ);
        if(read) {
            pc.printf("x%3d y%3d c%1d z%1d ------", joyX>>1, joyY>>1, buttonC, buttonZ);
            pc.printf("x%d y%d z%d\n\r", accX, accY, accZ);
            if(buttonC!=0){
                TFT.cls();
            }
            TFT.fillrect(joyX>>1,128-(joyY>>1),10+(joyX>>1) ,10+128-(joyY>>1),White);
            //TFT.fillrect(10,100,12,150,White);
        } else {
            printf("Error\n");
        }
        wait(0.01);
    }
}
