#ifndef MBED_SPIFILESYSTEM_H
#define MBED_SPIFILESYSTEM_H

#include "mbed.h"
#include "USBFileSystem.h"
#include <stdint.h>

/** Access the filesystem on an EEPROM using SPI using SPI
 *
 * @code
 * #include "mbed.h"
 * #include "USBSPIFileSystem.h"
 *
 * USBSPIFileSystem e2prom("e2prom", p5, p6, p7, p12); // mosi, miso, sclk, cs
 *  
 * int main() {
 *     FILE *fp = fopen("/e2prom/myfile.txt", "w");
 *     fprintf(fp, "Hello World!\n");
 *     fclose(fp);
 * }
 */
class USBSPIFileSystem : public USBFileSystem {
public:

    /** Create the File System for accessing an EEPROM using SPI
     *
     * @param mosi SPI mosi pin connected to SPI EEPROM
     * @param miso SPI miso pin conencted to SPI EEPROM
     * @param sclk SPI sclk pin connected to SPI EEPROM
     * @param cs   DigitalOut pin used as SPI EEPROM chip select
     * @param name The name used to access the virtual filesystem
     */
    USBSPIFileSystem(const char *name, PinName mosi, PinName miso, PinName sclk, PinName cs);
    virtual int disk_initialize();
    virtual int _disk_status();
    virtual int disk_read(uint8_t * buffer, uint64_t sector, uint8_t count);
    virtual int _disk_write(const uint8_t * buffer, uint64_t sector, uint8_t count);
    virtual int disk_sync();
    virtual uint64_t disk_sectors();

protected:

    int initialise_card();
    
    uint64_t _sectors;
    
    uint8_t _status;

    SPI _spi;
    DigitalOut _cs;
    int cdv;
};

#endif
