/* a copy of the SDFileSystem library...
 * but adapted for class 'USBSPIFileSystem'!
 *
 * WILL BE TESTED ONLY WITH 25LC1024(Microchip)
 */


#include "USBSPIFileSystem.h"
#include "mbed_debug.h"

#define SD_COMMAND_TIMEOUT 5000

#define SD_DBG             0

USBSPIFileSystem::USBSPIFileSystem(const char *name, PinName mosi, PinName miso, PinName sclk, PinName cs) :
    USBFileSystem(name), _spi(mosi, miso, sclk), _cs(cs) 
{
    _cs = 1;
    //no init
    _status = 0x01;
//    wait (1);
    connect();
}
/*
#define R1_IDLE_STATE           (1 << 0)
#define R1_ERASE_RESET          (1 << 1)
#define R1_ILLEGAL_COMMAND      (1 << 2)
#define R1_COM_CRC_ERROR        (1 << 3)
#define R1_ERASE_SEQUENCE_ERROR (1 << 4)
#define R1_ADDRESS_ERROR        (1 << 5)
#define R1_PARAMETER_ERROR      (1 << 6)

// Types
//  - v1.x Standard Capacity
//  - v2.x Standard Capacity
//  - v2.x High Capacity
//  - Not recognised as an SD Card
#define SDCARD_FAIL 0
#define SDCARD_V1   1
#define SDCARD_V2   2
#define SDCARD_V2HC 3
*/
int USBSPIFileSystem::disk_initialize() {
    _spi.frequency(5000000); // Set to 5MHz for data transfer

    _sectors = 2048; //1024*1024/512 = 1024*2 = 2048

    // OK
    _status = 0x00;

    return 0;
}

int USBSPIFileSystem::_disk_write(const uint8_t * buffer, uint64_t sector, uint8_t count=1) {
    // set write address for single block (CMD24)
    uint64_t _sector = sector;

    // send the data block
    _cs = 0;

    for(int i = 0;i<2;i++){ //0,1
        _sector = sector<<(8+i);
        _spi.write(0x02); //WRITE
        _spi.write(0xff & (_sector>>16)); //MSB
        _spi.write(0xff & (_sector>>8)); //
        _spi.write(0xff & (_sector)); //LSB
        for(int j = (256*i); j < (256<<i); j++){
            _spi.write(buffer[j]);
        }
    }

    _cs = 1;

//    _write(buffer, 512);
    return 0;
}

int USBSPIFileSystem::disk_read(uint8_t * buffer, uint64_t sector, uint8_t count=1) {
    // set read address for single block (CMD17)
    uint64_t _sector = sector;

    // send the data block
    _cs = 0;

    for(int i = 0;i<2;i++){ //0,1
        _sector = sector<<(8+i);
        _spi.write(0x03); // READ
        _spi.write(0xff & (_sector>>16)); //MSB
        _spi.write(0xff & (_sector>>8)); //
        _spi.write(0xff & (_sector)); //LSB
        for(int j = (256*i); j < (256<<i); j++){
            buffer[j] = _spi.write(0xAA);
        }
    }

    _cs = 1;

    // receive the data
//    _read(buffer, 512);
    return 0;
}

int USBSPIFileSystem::_disk_status() { return _status; }
int USBSPIFileSystem::disk_sync() { return 0; }
uint64_t USBSPIFileSystem::disk_sectors() { return _sectors; }
