#ifndef MBED_SDFILESYSTEM_H
#define MBED_SDFILESYSTEM_H

#include "mbed.h"
#include "USBFileSystem.h"
#include <stdint.h>

/** Access the filesystem on an SD Card using SPI
 *
 * @code
 * #include "mbed.h"
 * #include "SDFileSystem.h"
 *
 * USBSDFileSystem sd("sd", p5, p6, p7, p12); // mosi, miso, sclk, cs
 *  
 * int main() {
 *     FILE *fp = fopen("/sd/myfile.txt", "w");
 *     fprintf(fp, "Hello World!\n");
 *     fclose(fp);
 * }
 */
class USBSDFileSystem : public USBFileSystem {
public:

    /** Create the File System for accessing an SD Card using SPI
     *
     * @param mosi SPI mosi pin connected to SD Card
     * @param miso SPI miso pin conencted to SD Card
     * @param sclk SPI sclk pin connected to SD Card
     * @param cs   DigitalOut pin used as SD Card chip select
     * @param name The name used to access the virtual filesystem
     */
    USBSDFileSystem(const char *name, PinName mosi, PinName miso, PinName sclk, PinName cs);
    virtual int disk_initialize();
    virtual int _disk_status();
    virtual int disk_read(uint8_t * buffer, uint64_t sector, uint8_t count);
    virtual int _disk_write(const uint8_t * buffer, uint64_t sector, uint8_t count);
    virtual int disk_sync();
    virtual uint64_t disk_sectors();

protected:

    int _cmd(int cmd, int arg);
    int _cmdx(int cmd, int arg);
    int _cmd8();
    int _cmd58();
    int initialise_card();
    int initialise_card_v1();
    int initialise_card_v2();
    
    int _read(uint8_t * buffer, uint32_t length);
    int _write(const uint8_t *buffer, uint32_t length);
    uint64_t _sd_sectors();
    uint64_t _sectors;
    
    uint8_t _status;

    SPI _spi;
    DigitalOut _cs;
    int cdv;
};

#endif
