#include "mbed.h"
#include "USBSDFileSystem.h"
#include "USBCDCMSC.h"

DigitalOut myled(LED1);
DigitalOut erled(LED2);

USBSDFileSystem sd("sd", p5, p6, p7, p8); // the pinout on the mbed testbed board // mosi, miso, sclk, cs
//USBSDFileSystem sd("sd", p11, p12, p13, p14); // the pinout on the mbed testbed board // mosi, miso, sclk, cs
//USBSDFileSystem sd("sd", P0_10, P0_22, P0_11, P0_12); // <<NO ERROR?!
//p7,p12,p15,p16
// pin 19,20,22,23

USBCDCMSC pc(&sd,0x1f00, 0x2012, 0x0001);

//#define BLE
#ifdef BLE
/*
//Serial pc(USBTX,USBRX); //->USBCDCMSC pc(&sd);
Serial ble(p9,p10);
// P0_19,P0_18
// pin 32,31

//LocalFileSystem local( "local" ); //->USBSDFileSystem sd("sd", p5, p6, p7, p8); // the pinout on the mbed testbed board // mosi, miso, sclk, cs
//#define     SOURCE_FILE         "/local/_bin"
#define     SOURCE_FILE         "/sd/_bin"

int file_size( FILE *fp );
enum XMODEM_CONST{
SOH = (0x01),
STX = (0x02),
EOT = (0x04),
ACK = (0x06),
DLE = (0x10),
NAK = (0x15),
CAN = (0x18),
};

int main()
{
    uint8_t recieve;
    uint8_t read;
    int filesize=0;
    FILE* fp;
    ble.baud(57600);
    int crc=0x00;

    if ( NULL == (fp = fopen( SOURCE_FILE, "rb" )) ) {
        exit(1);
//        return ( ERROR_AT_FILE_OPEN );
    }else{
        filesize=file_size(fp);
        pc.printf("0x%04X\n\r",filesize);
    }

    while(1) {
        recieve=ble.getc();
        if(recieve == STX) {
            ble.putc(SOH);
            pc.putc('!');
            break;
        }
    }
    ble.putc(filesize&0xff);
    ble.putc( (filesize>>8)&0xff);
    while(1) {
        recieve=ble.getc();
        if(recieve == ACK) {
            pc.printf("ok!\n\r");
//            ble.putc(0x01);
            break;
        }
    }
    for(int i=0;i<filesize;i++){
        read=getc(fp);
        ble.putc(read);
        crc=crc^read;
        if((i%16)==0){
            pc.printf("\n\r");
        }
        pc.printf("%02X ",read);
    }
    pc.printf("\n\r0x%02X ",crc);
    while(1) {
        recieve=ble.getc();
        if(recieve == crc) {
            ble.putc(ACK);
            pc.printf("-=-=DONE=-=-\n\r");
            break;
        }
    }
    fclose(fp);
    myled = 1;
    while(1) {
        recieve=ble.getc();
        pc.putc(recieve);
        wait_ms(20);
    }
}

int file_size( FILE *fp )
{
    int     size;

    fseek( fp, 0, SEEK_END ); // seek to end of file
    size    = ftell( fp );    // get current file pointer
    fseek( fp, 0, SEEK_SET ); // seek back to beginning of file

    return size;
}
*/
#else //BLE

void mylog (int i)
{
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
    if(fp == NULL) {
        erled = 0;
        pc.printf("Could not open file for write\n\r");
    } else {
        erled = 1;
        fprintf(fp, "[%d]Hello fun SD Card World!\n\n\r", i);
        pc.printf("appending: '[%d]Hello fun SD Card World!'\n\r", i);
        //fclose(fp);
    }
    fclose(fp);
}

int main()
{
    sd.disconnect();
    mkdir("/sd/mydir", 0777);
//    mylog (100);
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
    for(int i=0; i<5; i++) {
        myled = 1;
        erled = 0;
        wait_ms (500);
        if(fp == NULL) {
            pc.printf("Could not open file for write\n\r");
        } else {
            fprintf(fp, "[%d]Hello fun SD Card World!\n\n\r", i);
            pc.printf("appending: '[%d]Hello fun SD Card World!'\n\r", i);
            //fclose(fp);
        }
        myled = 0;
        erled = 1;
        wait_ms (500);
    }
    fclose(fp);
    sd.usbMode(1); // allow fopen/fprintf when connected with USB-drive.
    sd.connect();
    /* pc.printf() and/or pc.getc() is not working. CDC packet dissappears*/
    for(int i=0; i<5; i++) {
        myled = 1;
        wait_ms (500);
        myled = 0;
        wait_ms (500);
    }
    pc.printf("Hello World!\n\n");

    pc.printf("now a USB drive should appear on your PC\n");
    pc.printf("create directory and append to log file\n");

    pc.printf("Entering loop of 1 min cycle time\n\r");
//    sd.usbMode (1); // allow fopen/fprintf when connected with USB-drive.
//    sd.connect(false);

    int i = 1;
    int recieve=0 ;
    while(true) {
        myled = 1;
        wait_ms (500);
        myled = 0;
        wait_ms (500);
        /*
                myled = 0;
                recieve=pc._getc();
                if(recieve != NULL){
                    pc._putc(recieve+1);
                }else{
                    pc._putc('+');
                }
                myled = 1;
                wait_us(200);
        */
    }
    return 0;
}
#endif //BLE
