#pragma once

/** StorageInterface class
*/
class StorageInterface {
public:
    StorageInterface() {
        report_read_count = 0;
        report_write_count = 0;
        report_sectors_count = 0;
        report_size_count = 0;
    }
    virtual int storage_read(uint8_t* data, uint32_t block) = 0;
    virtual int storage_write(const uint8_t* data, uint32_t block) = 0;
    virtual uint32_t storage_sectors() = 0;
    virtual uint32_t storage_size() = 0;

    __IO int report_read_count;
    __IO int report_write_count;
    __IO int report_sectors_count;
    __IO int report_size_count;
};
