#include "Storage.h"
#include "FATFileSystem.h"
#include <ctype.h>

#if (DEBUG2 > 3)
#define STORAGE_DBG(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);fprintf(stderr,"\r\n");} while(0);
#else
#define STORAGE_DBG(...)
#endif

LocalStorage::LocalStorage(StorageInterface* storage, const char* name)
        : FATFileSystem(name),_storage(storage)
{
    _name = name;
}

static bool match1(const char* name, const char* pat) {
	while(1) {
    	char c = *pat++;
    	char d = *name++;
        if (c == '\0' && d == '\0') {
        	return true;
        } else if (c == '\0' || d == '\0') {
        	return false;
        }
    	switch(c) {
    	    case '?':
    	    	break;
    	    case '*':
    	    	name--;
    	    	while(*name) {
    	    		if (*name == '.') {
    	    			break;
    	    		}
    	    		name++;
    	    	}
    	    	break;
    	    default:
    	    	if (toupper(d) != toupper(c)) {
    	    		return false;
    	    	}
    	    	break;
    	}
    }
}

extern FILINFO FATDirHandle_finfo; // fat/FATDirHandle.cpp
/* static */ bool LocalStorage::find(char* name, size_t size, const char* dirname, const char* pat)
{
    char dirpath[32];
    strcpy(dirpath, "/");
    if (strlen(dirname) >= sizeof(dirpath)-2) {
    	return false;
    }
    strcat(dirpath, dirname);
    DIR *dir = ::opendir(dirpath);
    if (dir == NULL) {
        return false;
    }
    uint32_t fdatetime = 0;
    bool found = false;
    struct dirent *entry;
    while ((entry = readdir(dir)) != NULL) {
        if (match1(entry->d_name, pat)) {
            FILINFO* fi = &FATDirHandle_finfo;
            uint32_t datetime =  fi->ftime | (fi->fdate<<16);
            STORAGE_DBG("datetime=%08x [%s]", datetime, entry->d_name);
            if (datetime > fdatetime) {
                fdatetime = datetime;
                if (strlen(dirpath) + 1 + strlen(entry->d_name) < size) {
                    strcpy(name, dirpath);
                    strcat(name, "/");
                    strcat(name, entry->d_name);
                    found = true;
                }
            }
        }
    }
    closedir(dir);
    return found;
}

