#include <stdlib.h>
#include <string.h>
#pragma once
class mystring {
public:
    mystring(){
        _init();
    }
    mystring(const char* s) {
        _init();
        append(s);
    }
    
    ~mystring() {
        if (_buf) {
            free(_buf);
        }
    }
    void clear() {
        if (_buf) {
            free(_buf);
        }
        _init();
    }
    bool empty() {
        return _len == 0;
    }
    size_t size() {
        return _len;
    }
    void append(const char* s, int len) {
        if (_buf == NULL) {
            return;
        }
        int new_len = _len + len;
        char* new_buf = (char*)malloc(new_len + 1);
        if (new_buf == NULL) {
            return;
        }
        memcpy(new_buf, _buf, _len);
        memcpy(new_buf+_len, s, len);
        new_buf[_len+len] = '\0';
        free(_buf);
        _buf = new_buf;
        _len += new_len;
    }
    void append(const char* s) {
        append(s, strlen(s));
    }
    void append(int c) {
        char buf[1];
        buf[0] = c;
        append(buf, sizeof(buf));
    }
    char* c_str() {
        if (_buf) {
            return _buf;
        }
        return "";
    }
    mystring& operator= (const char* s) {
        _init();
        append(s);
        return *this;
    }
    mystring& operator+= (const char* s) {
        append(s);
        return *this;
    }
    char& operator[] (size_t pos) {
        return _buf[pos];
    }
private:
    void _init() {
        _len = 0;
        _buf = (char*)malloc(1);
        if (_buf) {
            _buf[0] = '\0';
        }
    }
    char* _buf;
    int _len;
};
