#include "mbed.h"
#include "StorageInterface.h"
#include "mymap.h"

class RamDisk : public StorageInterface {
public:
    RamDisk(int sectors = 128); // 128*512 64Kbytes
    virtual int storage_read(uint8_t* data, uint32_t block);
    virtual int storage_write(const uint8_t* data, uint32_t block);
    virtual uint32_t storage_sectors();
    virtual uint32_t storage_size();

    void dump(int mode);

private:
    void format();
    int _sectors;
    mymap<int,uint8_t*>_sector_image;
};
