#include "USBLocalFileSystem.h"
#include "RamDisk.h"
#include "SDStorage.h"
#include "USB_CDC.h"

USBLocalFileSystem::USBLocalFileSystem(const char* name)
{
    RamDisk* storage = new RamDisk;
    init(storage, name);
}

USBLocalFileSystem::USBLocalFileSystem(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name)
{
    SDStorage* storage = new SDStorage(mosi, miso, sclk, cs);
    storage->storage_initialize();
    init(storage, name);
}

USBLocalFileSystem::USBLocalFileSystem(StorageInterface* storage, const char* name)
{
    init(storage, name);
}

void USBLocalFileSystem::init(StorageInterface* storage, const char* name)
{
    _name = name;
    _storage = storage;
    _usb = new USBStorage2(_storage);
    _local = new LocalStorage(_storage);    
}

void USBLocalFileSystem::remount()
{
    if (_local) {
        delete _local;
    }    
    _local = new LocalStorage(_storage); 
}

int USBLocalFileSystem::lock(bool f)
{
	return _usb->block(f);
}

bool USBLocalFileSystem::find(char* name, size_t size, const char* pat)
{
    return LocalStorage::find(name, size, _name, pat);
}

int USBLocalFileSystem::readable()
{
    return _usb->readable();
}

int USBLocalFileSystem::writeable()
{
    return _usb->writeable();
}

int USBLocalFileSystem::getc()
{
    return _usb->getc();
}

int USBLocalFileSystem::putc(int c)
{
    _usb->putc(c);
    return c;
}

int USBLocalFileSystem::puts(const char* str)
{
	while(*str) {
		putc(*str++);
	}
	return 0;
}

void USBLocalFileSystem::attachSendBreak(void (*fptr)(uint16_t duration))
{
	getUsb()->getCDC()->attachSendBreak(fptr);
}

void USBLocalFileSystem::attachControlLineState(void (*fptr)(int dts, int dtr))
{
	getUsb()->getCDC()->attachControlLineStateChanged(fptr);
}

void USBLocalFileSystem::attachSettingChanged(void (*fptr)(int baud, int bits, int parity, int stop))
{
	getUsb()->getCDC()->attach(fptr);
}

