/** this is for HD44780 compatible 16x2 charachter LCD with HC595 by bitbanging
* by Kazuki Yamamoto, or _K4ZUKI_
*/

#ifndef __TRIPINLCD_H__
#define __TRIPINLCD_H__

#include <inttypes.h>
#include "mbed.h"
#include "ShiftOut.h"

// commands
#define LCD_CLEARDISPLAY 0x01
#define LCD_RETURNHOME 0x02
#define LCD_ENTRYMODESET 0x04
#define LCD_DISPLAYCONTROL 0x08
#define LCD_CURSORSHIFT 0x10
#define LCD_FUNCTIONSET 0x20
#define LCD_SETCGRAMADDR 0x40
#define LCD_SETDDRAMADDR 0x80

// flags for display entry mode
#define LCD_ENTRYRIGHT 0x00
#define LCD_ENTRYLEFT 0x02
#define LCD_ENTRYSHIFTINCREMENT 0x01
#define LCD_ENTRYSHIFTDECREMENT 0x00

// flags for display on/off control
#define LCD_DISPLAYON 0x04
#define LCD_DISPLAYOFF 0x00
#define LCD_CURSORON 0x02
#define LCD_CURSOROFF 0x00
#define LCD_BLINKON 0x01
#define LCD_BLINKOFF 0x00

// flags for display/cursor shift
#define LCD_DISPLAYMOVE 0x08
#define LCD_CURSORMOVE 0x00
#define LCD_MOVERIGHT 0x04
#define LCD_MOVELEFT 0x00

// flags for function set
#define LCD_3WIERMODE 0x20
#define LCD_8BITMODE 0x10
#define LCD_4BITMODE 0x00
#define LCD_2LINE 0x08
#define LCD_1LINE 0x00
#define LCD_5x10DOTS 0x04
#define LCD_5x8DOTS 0x00

//#define SHIFT_RS (0x02) //B00000010
#define SHIFT_RS (0x01) //B00000010
#define SHIFT_EN (0x08) //B00001000

#define DATA_BYTE (1)
#define CMND_BYTE (0)

/** tripinLcd
 * mbed library for HD44780 compatible charachter LCD with HC595 by bitbanging
 *
 * Example:
 * @code
#include "mbed.h"
#include "TriPinLcd.h"

Timer t;
TriPinLcd lcd(p5,p7,p6);//clk = p7, data = p5, latch = p6

int main()
{

    lcd.begin(16, 2);
    lcd.noBlink();

    lcd.printf("LCD3WIRE mbed");
    t.start();
    while(1) {
        lcd.setCursor(0, 1);
//        lcd.printf("%.0f", t.read());
        lcd.printf("%d", t.read_us());
    }
}

 * @endcode
 */

class TriPinLcd : public Stream
{

public:
    /** Constructor
    * @param data data input
    * @param clock clock input
    * @param latch latches HC595 and sends data to LCD
    */
    TriPinLcd(PinName data, PinName clock, PinName latch);

    void begin(uint8_t cols, uint8_t rows, uint8_t dotsize = LCD_5x8DOTS);
    
    /**
    clears display, set cursor position to zero
    */
    void clear();
    
    /**
    set cursor position to zero
    */
    void home();
    /**
     Turn the display off
    */
    void noDisplay();
    /**
     Turn the display on
    */
    void display();
    /**
    Turns off the blinking cursor
    */
    void noBlink();
    /**
    Turns on the blinking cursor
    */
    void blink();
    /**
    Turns the underline cursor off
    */
    void noCursor();
    /**
    Turns the underline cursor on
    */
    void cursor();
    /**
    scroll the display to left without changing the RAM
    */
    void scrollDisplayLeft();
    /**
    scroll the display to right without changing the RAM
    */
    void scrollDisplayRight();
    /**
    This is for text that flows Left to Right
    */
    void leftToRight();
    /**
    This is for text that flows Right to Left
    */
    void rightToLeft();
    /**
    This will 'right justify' text from the cursor
    */
    void autoscroll();
    /**
    This will 'left justify' text from the cursor
    */
    void noAutoscroll();

    /**
    Allows us to fill the first 8 CGRAM locations
    with custom characters
    */
    void createChar(uint8_t, uint8_t[]);
    /**
    set cursor position to (x=col,y=row); (0,0) is left-top
    @param col X position
    @param row Y position
    */
    void setCursor(uint8_t, uint8_t);


private:
    ShiftOut::ShiftOut _lcd;
    void _write(uint8_t);
    void _command(uint8_t);

    virtual int _putc(int value);
    virtual int _getc();

    void _send(uint8_t, uint8_t);
    void _write4bits(uint8_t);

    uint8_t _displayfunction;
    uint8_t _displaycontrol;
    uint8_t _displaymode;

    uint8_t _numlines,_currline;

};

#endif