#ifndef SHIFTOUT_H
#define SHIFTOUT_H

#include <mbed.h>

class ShiftOut
{

public :

    ShiftOut(PinName data, PinName clk, PinName latch, int8_t registerCount = 8) {
        dataout = new DigitalOut(data);
        clkout = new DigitalOut(clk);
        latchout = new DigitalOut(latch);
        this->registerCount = registerCount;
    }

    ~ShiftOut() {
        delete clkout;
        delete dataout;
        delete latchout;
    }

    void write(int8_t data) {
        *latchout = 0;
        for(int i = registerCount - 1; i >=  0; i--) {
            *clkout = 0;
            wait_us(0.01);
            *dataout = (data & (1 << i)) != 0; // 1 or 0
            *clkout = 1;
            wait_us(0.01);
        }
        *latchout = 1;
    }

private :
    DigitalOut *clkout;
    DigitalOut *dataout;
    DigitalOut *latchout;
    int8_t registerCount;
};

#endif