#include "mbed.h"
#include "SeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

DigitalOut myled(LED1);
SeeedStudioTFTv2 LCD(A3,A1,A2,A0,
                     D11,D12,D13,
                     D5,D6,D7,
                     NC);
/*
SeeedStudioLCDv2::SeeedStudioLCDv2(PinName xp, PinName xm, PinName yp, PinName ym,
                                   PinName mosi, PinName miso, PinName sclk,
                                   PinName csLCD, PinName dcLCD, PinName blLCD,
                                   PinName csSd):
*/
int main()
{

    LCD.background(Black);
    LCD.foreground(White);
    LCD.cls();
 
    //Print a welcome message
    LCD.set_font((unsigned char*) Arial12x12);
    LCD.locate(0,0);
    LCD.printf("Hello Mbed");
 
    //Wait for 5 seconds
    wait(5.0);
 
    //Draw some graphics
    LCD.cls();
    LCD.set_font((unsigned char*) Arial24x23);
    LCD.locate(100,100);
    LCD.printf("Graphic");
 
    LCD.line(0,0,100,0,Green);
    LCD.line(0,0,0,200,Green);
    LCD.line(0,0,100,200,Green);
 
    LCD.rect(100,50,150,100,Red);
    LCD.fillrect(180,25,220,70,Blue);
 
    LCD.circle(80,150,33,White);
    LCD.fillcircle(160,190,20,Yellow);
 
    double s;
    for (int i = 0; i < 320; i++) {
        s = 20 * sin((long double)i / 10);
        LCD.pixel(i, 100 + (int)s, Red);
    }
 
    //Wait for 5 seconds
    wait(5.0);
 
    //Multiple fonts
    LCD.foreground(White);
    LCD.background(Blue);
    LCD.cls();
    LCD.set_font((unsigned char*) Arial24x23);
    LCD.locate(0,0);
    LCD.printf("Different Fonts :");
    LCD.set_font((unsigned char*) Neu42x35);
    LCD.locate(0,30);
    LCD.printf("Hello Mbed 1");
    LCD.set_font((unsigned char*) Arial24x23);
    LCD.locate(20,80);
    LCD.printf("Hello Mbed 2");
    LCD.set_font((unsigned char*) Arial12x12);
    LCD.locate(35,120);
    LCD.printf("Hello Mbed 3");
}
