
#include "mbed.h"
#include "AkiSpiLcd.h"

//AkiSpiLcd LCD(MISO, MOSI, SCK, CSL, CSR);
//AkiSpiLcd LCDRAM(p11, p12, p13, p9, p10);
AkiSpiLcd LCDRAM(p5, p6, p7, p9, p10);
uint8_t lineBuffer[RAMLINE_LENGTH];

// SYSTEM --------------------------------------------------
uint8_t mainCounter;
// GAME ----------------------------------------------------
int scrollX=2,scrollY;
// BOX -----------------------------------------------------
int8_t boxPosi[8][3] = {
    {-78,-78,-78},{-78,+78,-78},{-78,+78,+78},{-78,-78,+78},
    {+78,-78,-78},{+78,+78,-78},{+78,+78,+78},{+78,-78,+78}
};
uint8_t boxLink[12][2] = {
    {0,1},{1,2},{2,3},{3,0},
    {4,5},{5,6},{6,7},{7,4},
    {0,4},{1,5},{2,6},{3,7}
};
int boxOffsetX;
int boxOffsetY;
int boxAngleX;
int boxAngleZ;
float buff3D[8][3];

// ASCII ---------------------------------
int8_t asciiPosi[9][2] = {
    {-6,-7},{ 0,-7},{+6,-7},
    {-6, 0},{ 0, 0},{+6, 0},
    {-6,+11},{ 0,+11},{+6,+11}
    /*
    {-6,-9},{ 0,-9},{+6,-9},
    {-6, 0},{ 0, 0},{+6, 0},
    {-6,+9},{ 0,+9},{+6,+9}
    */
};
uint8_t asciiLink[10 + 26][6][2] = {
    {{0,2},{2,8},{8,6},{6,0},{0,0},{0,0}},  // 0
    {{1,7},{1,7},{0,0},{0,0},{0,0},{0,0}},  // 1
    {{0,2},{2,5},{3,5},{3,6},{6,8},{0,0}},  // 2
    {{0,2},{3,5},{6,8},{2,8},{0,0},{0,0}},  // 3
    {{0,3},{3,5},{2,8},{0,0},{0,0},{0,0}},  // 4
    {{0,2},{0,3},{3,5},{5,8},{6,8},{0,0}},  // 5
    {{0,2},{0,6},{3,5},{5,8},{6,8},{0,0}},  // 6
    {{0,2},{2,7},{0,0},{0,0},{0,0},{0,0}},  // 7
    {{0,2},{0,6},{2,8},{3,5},{6,8},{0,0}},  // 8
    {{0,2},{0,3},{3,5},{2,5},{5,7},{0,0}},  // 9
    {{1,3},{3,6},{1,5},{5,8},{0,0},{0,0}},  // A
    {{0,2},{2,3},{3,8},{6,8},{0,6},{0,0}},  // B
    {{0,2},{0,6},{6,8},{0,0},{0,0},{0,0}},  // C
    {{0,5},{6,5},{0,6},{0,0},{0,0},{0,0}},  // D
    {{0,2},{0,6},{3,5},{6,8},{0,0},{0,0}},  // E
    {{0,2},{0,6},{3,5},{0,0},{0,0},{0,0}},  // F
    {{0,2},{0,6},{6,8},{5,8},{4,5},{0,0}},  // G
    {{0,6},{3,5},{2,8},{0,0},{0,0},{0,0}},  // H
    {{1,7},{0,0},{0,0},{0,0},{0,0},{0,0}},  // I
    {{2,8},{6,8},{3,6},{0,0},{0,0},{0,0}},  // J
    {{0,6},{2,3},{3,8},{0,0},{0,0},{0,0}},  // K
    {{0,6},{6,8},{0,0},{0,0},{0,0},{0,0}},  // L
    {{0,6},{0,4},{2,4},{2,8},{0,0},{0,0}},  // M
    {{0,6},{0,8},{2,8},{0,0},{0,0},{0,0}},  // N
    {{0,6},{0,2},{2,8},{6,8},{0,0},{0,0}},  // O
    {{0,2},{2,5},{3,5},{0,6},{0,0},{0,0}},  // P
    {{0,2},{0,6},{2,5},{5,7},{6,7},{4,8}},  // Q
    {{0,2},{2,5},{3,5},{0,6},{3,8},{0,0}},  // R
    {{0,2},{0,3},{3,5},{5,8},{6,8},{0,0}},  // S
    {{0,2},{1,7},{0,0},{0,0},{0,0},{0,0}},  // T
    {{0,6},{6,8},{2,8},{0,0},{0,0},{0,0}},  // U
    {{0,7},{2,7},{0,0},{0,0},{0,0},{0,0}},  // V
    {{0,6},{4,6},{4,8},{2,8},{0,0},{0,0}},  // W
    {{0,8},{2,6},{0,0},{0,0},{0,0},{0,0}},  // X
    {{0,4},{2,4},{4,7},{0,0},{0,0},{0,0}},  // Y
    {{0,2},{2,6},{6,8},{0,0},{0,0},{0,0}},  // Z
};
int buff2D[9][2];
int asciiAngle;

/*
void dotSet(int posX, int posY)
{
    int ramAddress;
    uint8_t data;
    if ((posX >= 0) && (posX < 400) && (posY >= 0) && (posY < 240)) {
        ramAddress = (posX / 8) + (posY * RAMLINE_LENGTH);
        data = LCDRAM.ram_read(ramAddress);
        data |= 0x80 >> (posX % 8);
        LCDRAM.ram_write(ramAddress, data);
    }
}
*/

int dotAddress = -1;
uint8_t dotData;
void dotSet(int posX, int posY) {
    if ((posX >= 0) && (posX < 416) && (posY >= 0) && (posY < 240)) {
        int address = (posX / 8) + (posY * RAMLINE_LENGTH);
        if (address != dotAddress) {
            dotAddress = address;
            dotData = LCDRAM.ram_read(dotAddress);
        }
        dotData |= 0x80 >> (posX % 8);
        LCDRAM.ram_write(dotAddress, dotData);
    }
}

void drawLine(int posX1, int posY1, int posX2, int posY2)
{
    float moveX = (float)(posX1 - posX2);
    float moveY = (float)(posY1 - posY2);
    int absX = abs((int)(moveX));
    int absY = abs((int)(moveY));
    int tmp;
    if (absX > absY) {
        tmp = absX;
    } else {
        tmp = absY;
    }
    moveX = moveX / (float)(tmp);
    moveY = moveY / (float)(tmp);
    for (int i = 0; i < tmp; i++) {
        dotSet(posX2 + moveX * i, posY2 + moveY * i);
    }
}

void ram2lcdAll()
{
//    LCDRAM.ram2lcd(0,240,SCREEN0);
    LCDRAM.ram2lcd(SCREEN0);
/*
    for (int y = 0; y < 240; y++) {
        LCDRAM.ram_read(y * RAMLINE_LENGTH+2,lineBuffer,RAMLINE_LENGTH);
        LCDRAM.directUpdateSingle(y + 1,lineBuffer);
    }
*/
}

void calcBox()
{
    float tmpX = boxAngleX * 3.141592653f / 180.0f;
    float tmpZ = boxAngleZ * 3.141592653f / 180.0f;
    float sinX = sin(tmpX);
    float cosX = cos(tmpX);
    float sinZ = sin(tmpZ);
    float cosZ = cos(tmpZ);
    for (int i = 0; i < 8; i++) {
        buff3D[i][0] = cosZ * boxPosi[i][0] - sinZ * boxPosi[i][1];
        buff3D[i][1] = sinZ * boxPosi[i][0] + cosZ * boxPosi[i][1];
        buff3D[i][2] = sinX * boxPosi[i][1] + cosX * boxPosi[i][2];
        buff3D[i][1] = cosX * boxPosi[i][1] - sinX * boxPosi[i][2];
        buff3D[i][0] = cosZ * boxPosi[i][0] - sinZ * buff3D[i][2];
        buff3D[i][2] = sinZ * boxPosi[i][0] + cosZ * buff3D[i][2];
    }
}

void drawBox()
{
    for (int i = 0; i < 12; i++) {
        drawLine((int)(buff3D[boxLink[i][0]][0]) + boxOffsetX, (int)(buff3D[boxLink[i][0]][1]) + boxOffsetY, (int)(buff3D[boxLink[i][1]][0]) + boxOffsetX, (int)(buff3D[boxLink[i][1]][1]) + boxOffsetY);
    }
}

void drawAscii(uint8_t num,int posX,int posY,int angle)
{
    float tmpA = angle * 3.141592653f / 180.0f;
    float tmpS = sin(tmpA);
    float tmpC = cos(tmpA);
    for (int i = 0; i < 9; i++) {
        buff2D[i][0] = (int)(tmpC * asciiPosi[i][0] - tmpS * asciiPosi[i][1]);
        buff2D[i][1] = (int)(tmpS * asciiPosi[i][0] + tmpC * asciiPosi[i][1]);
    }
    for (int i = 0; i < 6; i++) {
        if ((asciiLink[num][i][0] != 0) || (asciiLink[num][i][1] != 0)) {
            drawLine(buff2D[asciiLink[num][i][0]][0] + posX,buff2D[asciiLink[num][i][0]][1] + posY,buff2D[asciiLink[num][i][1]][0] + posX,buff2D[asciiLink[num][i][1]][1] + posY);
        }
    }
}

void rollAscii()
{
    for (int i = 0; i < (10 + 26); i++) {
        int angle = (asciiAngle + i * 8) % 360;
        float tmpA = angle * 3.141592653f / 180.0f;
        float tmpS = sin(tmpA);
        float tmpC = cos(tmpA);
        drawAscii(i,(int)(tmpC * 400.0f / 2.9f - tmpS * 400.0f / 2.9f + 400.0f / 2.0f),(int)(tmpS * 240.0f / 2.9f + tmpC * 240.0f / 2.9f + 240.0f / 2.0f),(angle + 135) % 360);
    }
}
// --------------------------------------------------------------------
// --------------------------------------------------------------------
uint16_t vaders[5];
uint8_t vaderLine[5] = {0,1,1,2,2};
uint8_t cgBuffer[3][2][2 * 8] = {
    {   {0x03,0x00,0x07,0x80,0x0f,0xc0,0x1b,0x60,0x1f,0xe0,0x04,0x80,0x0b,0x40,0x14,0xa0},
        {0x00,0x30,0x00,0x78,0x00,0xfc,0x01,0xb6,0x01,0xfe,0x00,0x84,0x01,0x02,0x00,0x84}
    },
    {   {0x08,0x20,0x04,0x40,0x0f,0xe0,0x1b,0xb0,0x3f,0xf8,0x2f,0xe8,0x28,0x28,0x06,0xc0},
        {0x01,0x04,0x04,0x89,0x05,0xfd,0x0b,0xb7,0x07,0xff,0x01,0xfc,0x01,0x04,0x00,0xd8}
    },
    {   {0x0f,0x00,0x7f,0xe0,0xff,0xf0,0xe6,0x70,0xff,0xf0,0x19,0x80,0x36,0xc0,0xc0,0x30},
        {
            0x00,0xf0,
            0x07,0xfe,
            0x0f,0xff,
            0x0e,0x67,
            0x0f,0xff,
            0x01,0x98,
            0x06,0x66,
            0x01,0x98,
        }
    },
};
void draw_vaders()
{
    uint8_t counter,tmp;
    for (int y = 0; y < 5; y++) {
        for (int x = 0; x < 11; x++) {
            if ((vaders[y] & (0x400 >> x)) != 0) {
                counter = 0;
                for (int i = 0; i < 8; i++) {
                    tmp = cgBuffer[vaderLine[y]][(mainCounter + scrollY) & 1][counter++];
                    if (tmp != 0) {
                        LCDRAM.ram_write((((y + scrollY) * 12 + i) * RAMLINE_LENGTH) + (x * 2 + scrollX + 0),tmp);
                    }
                    tmp = cgBuffer[vaderLine[y]][(mainCounter + scrollY) & 1][counter++];
                    if (tmp != 0) {
                        LCDRAM.ram_write((((y + scrollY) * 12 + i) * RAMLINE_LENGTH) + (x * 2 + scrollX + 1),tmp);
                    }
                }
            }
        }
    }
}
void init_vaders()
{
    for (int i = 0; i < 5; i++) {
        vaders[i] = 0x7ff;
    }
}
void gameControl()
{
    if ((mainCounter & 1) == 0) {
        if ((scrollY & 1) == 0) {
            if (++scrollX > 30) {
                scrollX--;
                scrollY++;
            }
        } else {
            if (--scrollX < 0) {
                scrollX++;
                scrollY++;
            }
        }
    }
}
// --------------------------------------------------------------------
// --------------------------------------------------------------------

int main()
{
    wait_ms(1);
    LCDRAM.cls();
    LCDRAM.cls_ram(SCREEN0);
    boxOffsetX = 416 / 2;
    boxOffsetY = 240 / 2;
    boxAngleX = 0;
    boxAngleZ = 0;
    init_vaders();
    while(1) {
        mainCounter++;
        gameControl();
        LCDRAM.cls_ram(SCREEN0);
        draw_vaders();
        calcBox();
        drawBox();
        rollAscii();
        ram2lcdAll();
        boxAngleX = (boxAngleX + 2) % 360;
        boxAngleZ = (boxAngleZ + 3) % 360;
        asciiAngle = (asciiAngle + 358) % 360;
    }
}
