/** original: p07gbar/code/TLV320_Write_test/
 * modify by k4zuki
 * to control Dialog DA7212 codec from FRDM-K64F/K66F
 * - FRDM
 *      - https://developer.mbed.org/platforms/FRDM-K64F/
 *          - I2S
 *              - I2S_TXD: PTC1
 *              - I2S_TX_FS: PTB19
 *              - I2S_TX_BCLK: PTB18
 *          - FXOS8700CQ - Accelerometer and Magnetometer
 *              - SCL:SCL
 *              - SDA:SDA
 *                  - 8-bit Address: 0x3A
 *      - https://developer.mbed.org/platforms/FRDM-K66F/
 *          - I2S
 *              - I2S_TXD: PTC1
 *              - I2S_TX_FS: PTE11
 *              - I2S_TX_BCLK: PTE12
 *          - FXOS8700CQ - Accelerometer and Magnetometer
 *              - SCL:SCL
 *              - SDA:SDA
 *                  - 8-bit Address: 0x3A
 *          - FXAS21002 - Gyroscope
 *              - SCL:SCL
 *              - SDA:SDA
 *                  - 8-bit Address: 0x42
 *          - 2 user push-buttons
 *          - RGB LED
 * - DA7212 (on-board(K66F) or off-board(K64F+ARD-AUDIO-7212))
 *      - https://developer.mbed.org/components/ARD-AUDIO-DA7212/
 *      - SCL:SCL
 *      - SDA:SDA
 *          - 8-bit address: 0x34
 * - Application Shield
 *      - https://developer.mbed.org/components/mbed-Application-Shield/
 *      - 3 Axis +/1 1.5g Accelerometer,I2C Interface  Freescale MMA7660
 *          - SCL: SCL
 *          - SDA: SDA
 *              - 8-bit Address: 0x98
 *      - Temperature sensor  LM75B
 *          - SCL: SCL
 *          - SDA: SDA
 *              - 8-bit Address: 0x90
 *      - 2 x Potentiometers  Iskra PNZ10ZA, 10k
 *          - Pot 1 (left) : A0
 *          - Pot 2 (right): A1
 *      - 5 way Joystick  ALPS SKRHADE010
 *          - Up: A2
 *          - Down: A3
 *          - Left: A4
 *          - Right: A5
 *          - Centre: D4
 *      - 128x32 Graphics LCD, SPI Interface  Newhaven C12332A1Z
 *          - A0: D7
 *          - nCS: D10
 *          - MOSI: D11
 *          - nRESET: D12
 *          - SCK: D13
 *      - RGB LED, PWM connected  Cree Inc CLV1A-FKB
 *          - Red: D5
 *          - Blue: D8
 *          - Green: D9
 *      - Speaker, PWM Connected  MULTICOMP  MCSMT-8030B-3717
 *          - D6
 *      - Xbee socket
 *          - Tx: D0
 *          - Rx: D1
 *          - Status: D2
 *          - nReset: D3
 */

#include "mbed.h"

AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

InterruptIn left(PTA4);
InterruptIn right(PTC6);

#include "FXOS8700.h"
FXOS8700 acc(PTD9, PTD8);
FXOS8700 mag(PTD9, PTD8);

#include "C12832.h"
C12832 lcd(D11, D13, D12, D7, D10);


#include "DA7212.h"
#include "FrdmI2s.h"
#define SAMPLERATE 32000
#include "sinelookup.h"
//DA7212 codec(I2C_SDA, I2C_SCL);
//TLV320 codec(I2C_SDA, I2C_SCL);
FrdmI2s i2s(PTC6,PTC1, PTE11, PTE12,TRANSMIT);

uint16_t phase_l;
uint16_t phase_r;
int minibuf[16];
unsigned short skipper;
unsigned short volume;

//float phase_kill;
//extern "C" void HardFault_Handler()
//{
//    error("Hard Fault!\n");
//}

void play(void)
{
    int to_write = i2s.get_fifo_limit() - (i2s.fifo_points());
    for(int i = 0; i < to_write; i+=2) {
        minibuf[i] = (int)sine16lookup[(SINE16LENGTH - 1) &( phase_l+skipper)];
        minibuf[i+1] = (int)sine16lookup[(SINE16LENGTH - 1) & (phase_r+skipper)];
    }
    i2s.write(minibuf, to_write);
}

Serial pc(USBTX,USBRX);

/* main */
int main()
{
    pc.baud(115200);
    skipper = pot1.read_u16() >> 8;
    volume = pot2.read_u16() >> 10;
    phase_l = 0;
    phase_r = 512;
    int to_write =0;
    int irq=0;

//     codec.power(true);
    // codec.frequency(SAMPLERATE);
    // codec.wordsize(16);
    // codec.master(false);
    // codec.headphone_volume(0.5);
//     codec.start();

    i2s.frequency(SAMPLERATE);
    i2s.wordsize(16);
    i2s.stereomono(FrdmI2s::STEREO);
    i2s.role(FrdmI2s::MASTER);
//    i2s.attach(&play);
    i2s.start();

    while(1) {
        pc.printf(".");
        wait_ms(50);
//        skipper = pot1.read_u16() >> 8;
//        volume = pot2.read_u16() >> 10; // 6-bit unsigned int
//        codec.headphone_volume((int)(volume));

        lcd.locate(0,3);
        lcd.printf("%08X",I2S0->TCSR);
        I2S0->TCSR |= I2S_TCSR_FEF(1);
//        lcd.printf("Volume: %+03d", (volume - 57));
//        lcd.locate(0,15);
//        lcd.printf("Skipper: %04d", skipper);
        irq = (I2S0->TCSR &I2S_TCSR_FEF_MASK) >> I2S_TCSR_FEF_SHIFT;
        to_write = i2s.get_fifo_limit() - (i2s.fifo_level());
        pc.printf("%d, %d\r",irq,to_write);
        for(int j=0;j<to_write ;j++){
            I2S0->TDR[0] = 0x55AA;
        }
    }
}
