#include "mbed.h"

DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);
Serial ble(p9,p10);

LocalFileSystem local( "local" );

#define     TARGET_FILE         "/local/_bin"

int file_size( FILE *fp );
enum XMODEM_CONST{
SOH = (0x01), 
STX = (0x02),
EOT = (0x04),
ACK = (0x06),
DLE = (0x10),
NAK = (0x15),
CAN = (0x18),
};

int main()
{
    uint8_t recieve;
    uint8_t read;
    int filesize=0;
    FILE* fp;
    ble.baud(57600);
    int crc=0x00;

    fp = fopen( TARGET_FILE, "rb" );
    if ( fp) {
        filesize=file_size(fp);
        pc.printf("0x%04X\n\r",filesize);
    }

    while(1) {
        recieve=ble.getc();
        if(recieve == STX) {
            ble.putc(SOH);
            pc.putc('!');
            break;
        }
    }
    ble.putc(filesize&0xff);
    ble.putc( (filesize>>8)&0xff);
    while(1) {
        recieve=ble.getc();
        if(recieve == ACK) {
            pc.printf("ok!\n\r");
//            ble.putc(0x01);
            break;
        }
    }
    for(int i=0;i<filesize;i++){
        read=getc(fp);
        ble.putc(read);
        crc=crc^read;
        if((i%16)==0){
            pc.printf("\n\r");
        }
        pc.printf("%02X ",read);
    }
    pc.printf("\n\r0x%02X ",crc);
    while(1) {
        recieve=ble.getc();
        if(recieve == crc) {
            ble.putc(ACK);
            pc.printf("-=-=DONE=-=-\n\r");
            break;
        }
    }
    fclose(fp);
    myled = 1;
    while(1) {
        recieve=ble.getc();
        pc.putc(recieve);
        wait_ms(20);
    }
}

int file_size( FILE *fp )
{
    int     size;

    fseek( fp, 0, SEEK_END ); // seek to end of file
    size    = ftell( fp );    // get current file pointer
    fseek( fp, 0, SEEK_SET ); // seek back to beginning of file

    return size;
}
