#include "mbed.h"
#include "Process.h"
#include "QEI.h"
#include <math.h>

#include "../../CommonLibraries/PID/PID.h"
#include "../../CommonLibraries/Ping/Ping.h"
#include "../../Communication/RS485/ActuatorHub/ActuatorHub.h"
#include "../../Communication/RS485/Master/Master.h"
#include "../../Communication/Controller/Controller.h"
#include "../../Input/ColorSensor/ColorSensor.h"
#include "../../Input/Switch/Switch.h"
#include "../../LED/LED.h"
#include "../../Safty/Safty.h"
#include "../Using.h"


using namespace SWITCH;
using namespace PID_SPACE;
using namespace COLORSENSOR;

static CONTROLLER::ControllerData *controller;
ACTUATORHUB::MOTOR::MotorStatus motor[MOUNTING_MOTOR_NUM];
ACTUATORHUB::SOLENOID::SolenoidStatus solenoid;

static bool lock;
static bool processChangeComp;
static int current;

static void AllActuatorReset();

#ifdef USE_SUBPROCESS
static void (*Process[USE_PROCESS_NUM])(void);
#endif

#pragma region USER-DEFINED_VARIABLES_AND_PROTOTYPE

/*Replace here with the definition code of your variables.*/
//************足回り*****************
void AllBrake();
void GoOshituke();
void GoMae();
void GoFront();
void GoBack();
void GoLeft();
void GoRight();
void GoHidariNanameMae();
void GoHidariNanameUshiro();
void GoMigiNanameMae();
void GoMigiNanameUshiro();

void RightTurning();
void LeftTurning();
uint8_t SetStatus(int);
uint8_t SetPWM(int);
bool move_flag = false;
//************足回り*****************

//************カラーセンサ********************

int Color_FR[3]; //[赤,緑,青]
int Color_FL[3];
int Color_RL[3];
int Color_RR[3];         
int intergration = 40;

int Avecolor_FR[3];
int Avecolor_FL[3];
int Avecolor_RL[3];
int Avecolor_RR[3];

void ColorIn();
void ColorDetection();
void getcolor();
//Ticker catch_colordata;
//************カラーセンサ********************

//************ライントレース変数*******************

int line_FR[3] = {500, 1000, 1400}; 
int line_FL[3] = {400, 1000, 1400};
int line_RL[3] = {180, 260, 150};
int line_RR[3] = {300, 1400, 1600};
/*
int line_FR[3] = {500, 1100, 1500}; 
int line_FL[3] = {300, 500, 380};
int line_RL[3] = {50, 100, 70};
int line_RR[3] = {300, 500, 300};
*/    
bool white_FR = false;
bool white_FL = false;
bool white_RL = false;
bool white_RR = false;
 
bool flag = false;    
bool invation_FR = false;
bool invation_FL = false;
bool invation_RL = false;
bool invation_RR = false;
bool on_line_flag = false;

void Move_On_the_Line();
void Move_On_the_Line_Trace();
void Move_On_the_Line_BackTrace();
void Move_On_the_Line_BACK();
void ColorDetection();
void Color_Changeflag();
//************ライントレース変数*******************

//************ROタコン******************
//QEI RtX(Rota_XA_PIN, Rota_XB_PIN, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
//QEI RtY(Rota_YA_PIN, Rota_YB_PIN, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
QEI Rota_FR(Rota_FR_A_PIN, Rota_FR_B_PIN, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
QEI Rota_FL(Rota_FL_A_PIN, Rota_FL_B_PIN, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
QEI Rota_RL(Rota_RL_A_PIN, Rota_RL_B_PIN, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
QEI Rota_RR(Rota_RR_A_PIN, Rota_RR_B_PIN, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);

Ticker ugokunoka_rps;
Ticker catch_rps;
//PID Rota_X = PID(0.03, -100, 50, 0.05, 0, 0);
//PID Rota_Y = PID(0.03, -100, 50, 0.05, 0, 0);
PID Get_pwm_FR = PID(0.03, -80, 80, 0.3,0,0);
PID Get_pwm_FL = PID(0.03, -80, 80, 0.3, 0, 0);
PID Get_pwm_RL = PID(0.03, -80, 80, 0.3, 0, 0);
PID Get_pwm_RR = PID(0.03, -80, 80, 0.3, 0, 0);

PID Catch_pwm_FR = PID(0.03, -100, 100, 0.3,0,0);
PID Catch_pwm_FL = PID(0.03, -100, 100, 0.3, 0, 0);
PID Catch_pwm_RL = PID(0.03, -100, 100, 0.3, 0, 0);
PID Catch_pwm_RR = PID(0.03, -100, 100, 0.3, 0, 0);

typedef struct {
    double FR;
    double FL;
    double RL;
    double RR;
}Tire;

Tire rps;
Tire p_rps;
Tire rotate;
Tire now;
Tire dist;

typedef struct {
    double x;
    double y;
}Vector;
//double target = 2561.00;
double target_FR = 0.00;
double target_FL = 0.00;
double target_RL = 0.00;
double target_RR = 0.00;

Vector goal = {1000.00,1000.00};
Vector rpm;
Vector dis;

int palseX;
int palseY;

double wantVal_FL = 0;
double wantVal_FR = 0;
double wantVal_RL = 0;
double wantVal_RR = 0;

typedef struct {
    int FR;
    int FL;
    int RL;
    int RR;
}Pwm;

int pwm_FR;
int pwm_FL;
int pwm_RL;
int pwm_RR;

Pwm pwm;
int hontoka = 0;

int vx;
int vy;
double max;
double ratio;
double max_rotate = 4.5;

void Rota_SetStatus(char,double);
void Get_rps();
void Get_Move();
void GoBack_Rota();
//************Buzzer*************
DigitalOut buzzer(BUZZER_PIN);
Ticker BuzzerTimer;
void BuzzerTimer_func();

//************動き***********
bool spot2400_flag = false;
bool spot1200_flag = false;
bool spot1500_flag = false;
bool spot1800_flag = false;
bool next_flag = true;
bool bluezone = true;
bool redzone = false;
bool once_flag = true;
bool debug_flag1 = true;

void CheckPoint();
void MovePoint();
void GoShoot();
/******超音波*****/
Ping Ping_0(PC_2);
Ping Ping_1(PC_3);
Ping Ping_2(PC_0);
Ping Ping_3(PC_1);
int select_kyori=0;
int select = 0;
int distance0 = 0;
int distance1 = 0;
int distance2 = 0;
int distance3 = 0;
bool ugoite_flag = true;
bool debug_flag = true;
bool temae_flag = false;
bool ugokanaide_flag = false;
bool ok_flag = false;
int zyouge = 0;
Serial pc(USBTX, USBRX);
bool ushiroate_flag = false;
bool kaeru_flag = false;
bool twin_flag = false;
bool idoutable_flag = false;
bool itido_flag = true;

int maeR = 0;
int maeL = 0;
int ushiroL = 0;
int ushiroR = 0;

Timeout launchTimer;
void launchTimer_func();
void launchTimer_func1();
void launchTimer_func2();
bool reset_flag = false;
bool rotarota_flag = false;
bool roller_flag = true;
#pragma endregion USER-DEFINED_VARIABLES_AND_PROTOTYPE

#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
static void Process0(void);
#endif
#if USE_PROCESS_NUM>1
static void Process1(void);
#endif
#if USE_PROCESS_NUM>2
static void Process2(void);
#endif
#if USE_PROCESS_NUM>3
static void Process3(void);
#endif
#if USE_PROCESS_NUM>4
static void Process4(void);
#endif
#if USE_PROCESS_NUM>5
static void Process5(void);
#endif
#if USE_PROCESS_NUM>6
static void Process6(void);
#endif
#if USE_PROCESS_NUM>7
static void Process7(void);
#endif
#if USE_PROCESS_NUM>8
static void Process8(void);
#endif
#if USE_PROCESS_NUM>9
static void Process9(void);
#endif
#endif

void SystemProcessInitialize()
{
#pragma region USER-DEFINED_VARIABLE_INIT
    /*Replace here with the initialization code of your variables.*/
    catch_rps.attach_us(&Get_rps,500);
    //catch_colordata.attach_us(&ColorDetection,30);
    //ugokunoka_rps.attach(&Get_Move,0.1);
    
#pragma endregion USER-DEFINED_VARIABLE_INIT

    AllActuatorReset();

    lock = true;
    processChangeComp = true;
    current = DEFAULT_PROCESS;

#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
    Process[0] = Process0;
#endif
#if USE_PROCESS_NUM>1
    Process[1] = Process1;
#endif
#if USE_PROCESS_NUM>2
    Process[2] = Process2;
#endif
#if USE_PROCESS_NUM>3
    Process[3] = Process3;
#endif
#if USE_PROCESS_NUM>4
    Process[4] = Process4;
#endif
#if USE_PROCESS_NUM>5
    Process[5] = Process5;
#endif
#if USE_PROCESS_NUM>6
    Process[6] = Process6;
#endif
#if USE_PROCESS_NUM>7
    Process[7] = Process7;
#endif
#if USE_PROCESS_NUM>8
    Process[8] = Process8;
#endif
#if USE_PROCESS_NUM>9
    Process[9] = Process9;
#endif
#endif
}

static void SystemProcessUpdate()
{
#ifdef USE_SUBPROCESS
    if(controller->Button.HOME) lock = false;

    if(controller->Button.START && processChangeComp) {
        current++;
        if (USE_PROCESS_NUM-1 < current) current = 0;
        processChangeComp = false;
    } else if(controller->Button.SELECT && processChangeComp) {
        current--;
        if (current < 0) current = USE_PROCESS_NUM-1;
        processChangeComp = false;
    } else if(!controller->Button.SELECT && !controller->Button.START) processChangeComp = true;
#endif

#ifdef USE_MOTOR
    ACTUATORHUB::MOTOR::Motor::Update(motor);
#endif

#ifdef USE_SOLENOID
    ACTUATORHUB::SOLENOID::Solenoid::Update(solenoid);
#endif

#ifdef USE_RS485
    MASTER::Master::Update();
    ACTUATORHUB::ActuatorHub::Update();
#endif

}

void SystemProcess()
{
    SystemProcessInitialize();

    while(1) {
#ifdef USE_MU
        controller = CONTROLLER::Controller::GetData();
#endif

#ifdef USE_ERRORCHECK
        if(SAFTY::ErrorCheck::Check() & SAFTY::Error::ControllerLost) {
            CONTROLLER::Controller::DataReset();
            //AllActuatorReset();
            //lock = true;
        } else
#endif
        {
#ifdef USE_SUBPROCESS
            if(!lock) {
                Process[current]();
            } else
#endif
            {
                //ロック時の処理
            }
        }
        LED_DEBUG0 = masterReceive.ems ? LED_ON : LED_OFF;
        if(masterReceive.zoneIsRed)
        {
            redzone = true;
            bluezone = false;
        }else if(!masterReceive.zoneIsRed)
        {
            redzone = false;
            bluezone = true;
        }
        if(masterReceive.ems)
        {
            masterSend.lowerRoller = false;
            masterSend.higherRoller = false;
            masterSend.launch = false;
            move_flag = false;
            white_FR = false;
            white_FL = false;
            white_RL = false;
            white_RR = false;
            flag = false;    
            invation_FR = false;
            invation_FL = false;
            invation_RL = false;
            invation_RR = false;
            on_line_flag = false;
            spot2400_flag = false;
            spot1200_flag = false;
            spot1500_flag = false;
            spot1800_flag = false;
            next_flag = true;
            once_flag = true;
            debug_flag1 = true;
            ugoite_flag = true;
            debug_flag = true;
            temae_flag = false;
            ugokanaide_flag = false;
            ok_flag = false;
            zyouge = 0;
            ushiroate_flag = false;
            kaeru_flag = false;
            twin_flag = false;
            idoutable_flag = false;
            itido_flag = true;
            roller_flag = true;
            reset_flag = false;
            current = 0;
            AllBrake();
            Rota_FR.reset();
            Rota_FL.reset();
            Rota_RL.reset();
            Rota_RR.reset();
            rotarota_flag = false;
            masterSend.rollerHeight = STOP;
            lock = false;
        }
        masterSend.processNum = lock ? 0x0f : current;
        
        static uint16_t cnt = 0;
        if(cnt >= 0x3fff) {
            LED_DEBUG0 = !LED_DEBUG0;
            cnt = 0;
        } else cnt++;
        
        SystemProcessUpdate();
    }
}

#pragma region PROCESS
#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
static void Process0()//二段テーブルへ移動か
{
    /*
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 49+maeR;
    motor[TIRE_FL].pwm = 52+maeL;
    motor[TIRE_RL].pwm = 55+ushiroL;
    motor[TIRE_RR].pwm = 57+ushiroR;
    if(controller->Button.R)
    {
        maeR++;
    }else if(controller->Button.L)
    {
        maeL++;
    }else if(controller->Button.ZL)
    {
        ushiroL++;
    }else if(controller->Button.ZR)
    {
        ushiroR++;
    }else if(controller->Button.A)
    {
        maeR = 0;
        maeL = 0;
        ushiroL = 0;
        ushiroR = 0;
    }*/
    /*
    if(controller->Button.UP)
    {
        GoMae();
    }else if(controller->Button.LEFT)
    {
        GoHidariNanameMae();
    }else if(controller->Button.RIGHT)
    {
        GoMigiNanameMae();
    }else{
        AllBrake();
    }
    */
    
    //ColorDetection();
    Color_Changeflag();
    if(bluezone)
    {
        if(masterReceive.startSw)
        {
            if(!(GO_2400up||GO_2400down) && GO_1800)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = 3500;
                target_FL = 3300;
                target_RL = -3500;
                target_RR = -3300;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = UE;
                zyouge = 4;
                idoutable_flag = true;
            }else if(!(GO_2400up||GO_2400down) && GO_1500)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = 3300;
                target_FL = 2900;
                target_RL = -3300;
                target_RR = -2900;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = MANNAKA;
                zyouge = 3;
                idoutable_flag = true;
            }else if(!(GO_2400up||GO_2400down) && GO_1200)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = 2000;
                target_FL = 1900;
                target_RL = -2000;
                target_RR = -1900;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
                idoutable_flag = true;
            }else if(GO_2400up && !GO_2400down)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = 300;
                target_FL = 2000;
                target_RL = -300;
                target_RR = -2000;
                masterSend.lowerRoller = false;
                masterSend.higherRoller = true;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
                twin_flag = true;
            }else if(!GO_2400up && GO_2400down)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = 300;
                target_FL = 2000;
                target_RL = -300;
                target_RR = -2000;
                masterSend.lowerRoller = true;
                masterSend.higherRoller = false;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
                twin_flag = true;
            }else if(GO_2400up && GO_2400down)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = 300;
                target_FL = 2000;
                target_RL = -300;
                target_RR = -2000;
                masterSend.lowerRoller = true;
                masterSend.higherRoller = true;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
                twin_flag = true;
            }
        }
    }else if(redzone)
    {
        if(masterReceive.startSw)
        {
            if(!(GO_2400up||GO_2400down) && GO_1800)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = -3300;
                target_FL = -3500;
                target_RL = 3300;
                target_RR = 3500;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = UE;
                zyouge = 4;
                idoutable_flag = true;
            }else if(!(GO_2400up||GO_2400down) && GO_1500)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = -2900;
                target_FL = -3300;
                target_RL = 2900;
                target_RR = 3300;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = MANNAKA;
                zyouge = 3;
                idoutable_flag = true;
            }else if(!(GO_2400up||GO_2400down) && GO_1200)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = -1900;
                target_FL = -2000;
                target_RL = 1900;
                target_RR = 2000;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
                idoutable_flag = true;
            }else if(!GO_2400up && GO_2400down)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = -2000;
                target_FL = -300;
                target_RL = 2000;
                target_RR = 300;
                masterSend.lowerRoller = true;
                masterSend.higherRoller = false;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
                twin_flag = true;
            }else if(GO_2400up && !GO_2400down)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = -2000;
                target_FL = -300;
                target_RL = 2000;
                target_RR = 300;
                masterSend.lowerRoller = false;
                masterSend.higherRoller = true;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
                twin_flag = true;
            }else if(GO_2400up||GO_2400down)
            {
                move_flag = true;
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = -2000;
                target_FL = -300;
                target_RL = 2000;
                target_RR = 300;
                masterSend.lowerRoller = true;
                masterSend.higherRoller = true;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
                twin_flag = true;
            }         
        }
    }
    
    if(bluezone)
    {
        if(twin_flag)
        {
            if(move_flag)
            {
                motor[TIRE_FR].dir = SetStatus(pwm.FR);
                motor[TIRE_FL].dir = SetStatus(pwm.FL);
                motor[TIRE_RL].dir = SetStatus(pwm.RL);
                motor[TIRE_RR].dir = SetStatus(pwm.RR);
                motor[TIRE_FR].pwm = SetPWM(pwm.FR);
                motor[TIRE_FL].pwm = SetPWM(pwm.FL);
                motor[TIRE_RL].pwm = SetPWM(pwm.RL);
                motor[TIRE_RR].pwm = SetPWM(pwm.RR);
            }
            if(dist.FL > target_FL - 5)current = 1;
        }
        if(idoutable_flag)
        {
            if(move_flag){
                motor[TIRE_FR].dir = SetStatus(pwm.FR);
                motor[TIRE_FL].dir = SetStatus(pwm.FL);
                motor[TIRE_RL].dir = SetStatus(pwm.RL);
                motor[TIRE_RR].dir = SetStatus(pwm.RR);
                motor[TIRE_FR].pwm = SetPWM(pwm.FR)*0.8;
                motor[TIRE_FL].pwm = SetPWM(pwm.FL)*0.3;
                motor[TIRE_RL].pwm = SetPWM(pwm.RL)*0.8;
                motor[TIRE_RR].pwm = SetPWM(pwm.RR)*0.3;
            }
            if(dist.FR > target_FR - 100) current = 4;
        }
    }
    if(redzone)
    {
        if(twin_flag)
        {
            if(move_flag)
            {
                motor[TIRE_FR].dir = SetStatus(pwm.FR);
                motor[TIRE_FL].dir = SetStatus(pwm.FL);
                motor[TIRE_RL].dir = SetStatus(pwm.RL);
                motor[TIRE_RR].dir = SetStatus(pwm.RR);
                motor[TIRE_FR].pwm = SetPWM(pwm.FR);
                motor[TIRE_FL].pwm = SetPWM(pwm.FL);
                motor[TIRE_RL].pwm = SetPWM(pwm.RL);
                motor[TIRE_RR].pwm = SetPWM(pwm.RR);
            }
            if(dist.RL > target_RL - 5)current = 1;
        }
        if(idoutable_flag)
        {
            if(move_flag){
                motor[TIRE_FR].dir = SetStatus(pwm.FR);
                motor[TIRE_FL].dir = SetStatus(pwm.FL);
                motor[TIRE_RL].dir = SetStatus(pwm.RL);
                motor[TIRE_RR].dir = SetStatus(pwm.RR);
                motor[TIRE_FR].pwm = SetPWM(pwm.FR)*0.3;
                motor[TIRE_FL].pwm = SetPWM(pwm.FL)*0.8;
                motor[TIRE_RL].pwm = SetPWM(pwm.RL)*0.3;
                motor[TIRE_RR].pwm = SetPWM(pwm.RR)*0.8;
            }
            if(dist.RR > target_RR - 100) current = 4;
        }
    }
    
    if(controller->Button.B){
        AllBrake();
        Rota_FR.reset();
        Rota_FL.reset();
        Rota_RL.reset();
        Rota_RR.reset();
        move_flag = false;
    }
}
#endif

#if USE_PROCESS_NUM>1
static void Process1()//二段テーブルの位置合わせ
{
    move_flag = false;
    ColorDetection();
    Color_Changeflag();
/*
    pc.printf("FR: red %d g %d b %d \n\r",Color_FR[0],Color_FR[1],Color_FR[2]);
    pc.printf("FL: red %d g %d b %d \n\r",Color_FL[0],Color_FL[1],Color_FL[2]);
    pc.printf("RL: red %d g %d b %d \n\r",Color_RL[0],Color_RL[1],Color_RL[2]);
    pc.printf("RR: red %d g %d b %d \n\r",Color_RR[0],Color_RR[1],Color_RR[2]);
*/    
    if(!flag)
    {
        if(LS_FL && LS_FR) 
        {
            AllBrake();
            flag = true;
        } else if(!LS_FL && LS_FR) {
            GoFront();
        }else if(LS_FL && !LS_FR) {
            GoFront();
        }else if(!LS_FL && !LS_FR){
            GoFront();
        }
    }
    if(flag){
        Move_On_the_Line();
    }
    if(on_line_flag)
    {
        ugokanaide_flag = true;
    }
    if(ugokanaide_flag)
    {
        if(LS_FL && LS_FR) 
        {
            masterSend.launch = true;
            AllBrake();
            if(roller_flag)
            {
                launchTimer.attach(launchTimer_func, 7);
                roller_flag = false;
            }
        } else if(!LS_FL && LS_FR) {
            GoFront();
        }else if(LS_FL && !LS_FR) {
            GoFront();
        }else if(!LS_FL && !LS_FR){
            GoFront();
        }
    }
    
    if(controller->Button.B){
        AllBrake();
        Rota_FR.reset();
        Rota_FL.reset();
        Rota_RL.reset();
        Rota_RR.reset();
        move_flag = false;
    }
}
#endif

#if USE_PROCESS_NUM>2
static void Process2()//二段テーブル終了後ろへ or スタートゾーンへ戻る
{
    masterSend.higherRoller = false;
    move_flag = false;
    if(GO_1200 || GO_1500 || GO_1800)
    {
        if(LS_RL && LS_RR) 
        {
            Rota_FR.reset();
            Rota_FL.reset();
            Rota_RL.reset();
            Rota_RR.reset();
            AllBrake();
            target_FR = 0;
            target_FL = 0;
            target_RL = 0;
            target_RR = 0;
            dist.FR = 0;
            dist.FL = 0;
            dist.RL = 0;
            dist.RR = 0;
            rotarota_flag = false;
            current = 3;
        }else if(!LS_RL && LS_RR) 
        {
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_RL].dir = FOR;
            motor[TIRE_RR].dir = FOR;
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FL].pwm = 60;
            motor[TIRE_RL].pwm = 0;
            motor[TIRE_RR].pwm = 0;
        }else if(LS_RL && !LS_RR) 
        {
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_RL].dir = BACK;
            motor[TIRE_RR].dir = BACK;
            motor[TIRE_FR].pwm = 60;
            motor[TIRE_FL].pwm = 0;
            motor[TIRE_RL].pwm = 0;
            motor[TIRE_RR].pwm = 0;
        }else if(!LS_RL && !LS_RR){
            GoBack_Rota();
        }
    }
    if(bluezone)
    {    
        if(!GO_1200 && !GO_1500 && !GO_1800)
        {
            if(itido_flag)
            {
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                target_FR = -550;
                target_FL = -2550;
                target_RL = 550;
                target_RR = 2550;
                itido_flag = false;
            }
            motor[TIRE_FR].dir = SetStatus(pwm.FR);
            motor[TIRE_FL].dir = SetStatus(pwm.FL);
            motor[TIRE_RL].dir = SetStatus(pwm.RL);
            motor[TIRE_RR].dir = SetStatus(pwm.RR);
            motor[TIRE_FR].pwm = SetPWM(pwm.FR);
            motor[TIRE_FL].pwm = SetPWM(pwm.FL);
            motor[TIRE_RL].pwm = SetPWM(pwm.RL);
            motor[TIRE_RR].pwm = SetPWM(pwm.RR);
        }
    }else if(redzone)
    {
        if(!GO_1200 && !GO_1500 && !GO_1800)
        {
            if(itido_flag)
            {
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                
                target_FR = 2650;
                target_FL = 400;
                target_RL = -2650;
                target_RR = -400;
                itido_flag = false;
            }
            motor[TIRE_FR].dir = SetStatus(pwm.FR);
            motor[TIRE_FL].dir = SetStatus(pwm.FL);
            motor[TIRE_RL].dir = SetStatus(pwm.RL);
            motor[TIRE_RR].dir = SetStatus(pwm.RR);
            motor[TIRE_FR].pwm = SetPWM(pwm.FR);
            motor[TIRE_FL].pwm = SetPWM(pwm.FL);
            motor[TIRE_RL].pwm = SetPWM(pwm.RL);
            motor[TIRE_RR].pwm = SetPWM(pwm.RR);
        }
    }
}
#endif

#if USE_PROCESS_NUM>3
static void Process3()//移動テーブルのライン手前までロタコンで移動
{
    if(!rotarota_flag)
    {
        if(bluezone)
        {
            if(GO_1200)
            {
                
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                rotarota_flag = true;        
                target_FR = 1000;
                target_FL = 900;
                target_RL = -1000;
                target_RR = -900;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
            }else if(!GO_1200 && GO_1500)
            {
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                rotarota_flag = true;
                target_FR = 1600;
                target_FL = 1500;
                target_RL = -1600;
                target_RR = -1500;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = MANNAKA;
                zyouge = 3;
            }else if(!GO_1200 && !GO_1500 && GO_1800)
            {   
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                rotarota_flag = true;
                target_FR = 2800;
                target_FL = 2700;
                target_RL = -2800;
                target_RR = -2700;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = UE;
                zyouge = 4;
            }
        }else if(redzone)
        {
            if(GO_1200)
            {
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                rotarota_flag = true;
                target_FR = -900;
                target_FL = -1000;
                target_RL = 900;
                target_RR = 1000;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = SHITA;
                zyouge = 2;
            }else if(!GO_1200 && GO_1500)
            {
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                rotarota_flag = true;
                target_FR = -1500;
                target_FL = -1600;
                target_RL = 1500;
                target_RR = 1600;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = MANNAKA;
                zyouge = 3;
            }else if(!GO_1200 && !GO_1500 && GO_1800)
            {   
                Rota_FR.reset();
                Rota_FL.reset();
                Rota_RL.reset();
                Rota_RR.reset();
                rotarota_flag = true;
                target_FR = -2700;
                target_FL = -2800;
                target_RL = 2700;
                target_RR = 2800;
                masterSend.lowerRoller = true;
                masterSend.rollerHeight = UE;
                zyouge = 4;
            }
        }
    }
    if(bluezone)
    {
        if(rotarota_flag)
        {
            motor[TIRE_FR].dir = SetStatus(pwm.FR);
            motor[TIRE_FL].dir = SetStatus(pwm.FL);
            motor[TIRE_RL].dir = SetStatus(pwm.RL);
            motor[TIRE_RR].dir = SetStatus(pwm.RR);
            motor[TIRE_FR].pwm = SetPWM(pwm.FR)*0.8;
            motor[TIRE_FL].pwm = SetPWM(pwm.FL)*0.3;
            motor[TIRE_RL].pwm = SetPWM(pwm.RL)*0.8;
            motor[TIRE_RR].pwm = SetPWM(pwm.RR)*0.3;
            if(dist.FR > target_FR-100)
            {
                current = 4;
            }
        }
    }else if(redzone)
    {
        if(rotarota_flag)
        {
            motor[TIRE_FR].dir = SetStatus(pwm.FR);
            motor[TIRE_FL].dir = SetStatus(pwm.FL);
            motor[TIRE_RL].dir = SetStatus(pwm.RL);
            motor[TIRE_RR].dir = SetStatus(pwm.RR);
            motor[TIRE_FR].pwm = SetPWM(pwm.FR)*0.3;
            motor[TIRE_FL].pwm = SetPWM(pwm.FL)*0.8;
            motor[TIRE_RL].pwm = SetPWM(pwm.RL)*0.3;
            motor[TIRE_RR].pwm = SetPWM(pwm.RR)*0.8;
            if(dist.RR > (target_RR-100))
            {
                current = 4;
            }
        }
    }
}
#endif

#if USE_PROCESS_NUM>4
static void Process4()//ライン位置合わせ
{
    rotarota_flag = false;
    masterSend.launch = false;
    roller_flag = true;
    once_flag = true;
    ColorDetection();
    Color_Changeflag();
    if (debug_flag)
    {
        on_line_flag = false;
        invation_FR = false;
        invation_FL = false;
        invation_RL = false;
        invation_RR = false; 
        flag = false;
        ok_flag = false;
        debug_flag = false;
        //ushiroate_flag = false;
    }
    Move_On_the_Line_BackTrace();
    if(on_line_flag)
    {
        if(LS_RL && LS_RR) 
            {
                current = 5;
                ok_flag = true;
                AllBrake();
            }else if(!LS_RL && LS_RR) 
            {
                motor[TIRE_FR].dir = FOR;
                motor[TIRE_FL].dir = FOR;
                motor[TIRE_RL].dir = FOR;
                motor[TIRE_RR].dir = FOR;
                motor[TIRE_FR].pwm = 0;
                motor[TIRE_FL].pwm = 40;
                motor[TIRE_RL].pwm = 0;
                motor[TIRE_RR].pwm = 0;
            }else if(LS_RL && !LS_RR) 
            {
                motor[TIRE_FR].dir = BACK;
                motor[TIRE_FL].dir = BACK;
                motor[TIRE_RL].dir = BACK;
                motor[TIRE_RR].dir = BACK;
                motor[TIRE_FR].pwm = 40;
                motor[TIRE_FL].pwm = 0;
                motor[TIRE_RL].pwm = 0;
                motor[TIRE_RR].pwm = 0;
            }else{
                GoBack();
            }
    }
    
    if(controller->Button.B){
        AllBrake();
        Rota_FR.reset();
        Rota_FL.reset();
        Rota_RL.reset();
        Rota_RR.reset();
        move_flag = false;
    }
}
#endif

#if USE_PROCESS_NUM>5
static void Process5()//最初の移動テーブルへライントレースし、投射
{
    if(LS_FL && LS_FR) 
    {
        masterSend.launch = true;
        rotarota_flag = false;
        AllBrake();
        move_flag = false;
        if(roller_flag)
        { 
            launchTimer.attach(launchTimer_func1, 3);
            roller_flag = false;
        }
    }else if(!LS_FL && LS_FR) {
        GoOshituke();
    }else if(LS_FL && !LS_FR) {
        GoOshituke();
    }else if(!LS_FL && !LS_FR){
        Move_On_the_Line_Trace();
    }
}
#endif

#if USE_PROCESS_NUM>6//下がる 
static void Process6()
{
    if(LS_RL && LS_RR) {
        Rota_FR.reset();
        Rota_FL.reset();
        Rota_RL.reset();
        Rota_RR.reset();
        AllBrake();
        rotarota_flag = false;
        target_FR = 0;
        target_FL = 0;
        target_RL = 0;
        target_RR = 0;
        dist.FR = 0;
        dist.FL = 0;
        dist.RL = 0;
        dist.RR = 0;
        current = 7;
    }else if(!LS_RL && LS_RR) {
        motor[TIRE_FR].dir = FOR;
        motor[TIRE_FL].dir = FOR;
        motor[TIRE_RL].dir = FOR;
        motor[TIRE_RR].dir = FOR;
        motor[TIRE_FR].pwm = 0;
        motor[TIRE_FL].pwm = 40;
        motor[TIRE_RL].pwm = 0;
        motor[TIRE_RR].pwm = 0;
    }else if(LS_RL && !LS_RR) {
        motor[TIRE_FR].dir = BACK;
        motor[TIRE_FL].dir = BACK;
        motor[TIRE_RL].dir = BACK;
        motor[TIRE_RR].dir = BACK;
        motor[TIRE_FR].pwm = 40;
        motor[TIRE_FL].pwm = 0;
        motor[TIRE_RL].pwm = 0;
        motor[TIRE_RR].pwm = 0;
    }else if(!LS_RL && !LS_RR){
        GoBack_Rota();
    }
}
#endif

#if USE_PROCESS_NUM>7
static void Process7()//次の移動テーブルのライン手前までロタコンで移動 or スタートゾーンへ戻る
{
    masterSend.launch = false;
    debug_flag1  = true;
    if(!rotarota_flag)
    {
        if(bluezone)
        {
            if(zyouge==2)
            {
                if(GO_1500)
                {
                    masterSend.rollerHeight = MANNAKA;
                    Rota_FR.reset();
                    Rota_FL.reset();
                    Rota_RL.reset();
                    Rota_RR.reset();
                    rotarota_flag = true;
                    target_FR = 400;
                    target_FL = 300;
                    target_RL = -400;
                    target_RR = -300;
                    zyouge = 3;
                }else if(!GO_1500 && GO_1800)
                {
                    masterSend.rollerHeight = UE;
                    Rota_FR.reset();
                    Rota_FL.reset();
                    Rota_RL.reset();
                    Rota_RR.reset();
                    rotarota_flag = true;
                    target_FR = 1100;
                    target_FL = 1000;
                    target_RL = -1100;
                    target_RR = -1000;
                    zyouge = 4;
                }else if(!GO_1500 && !GO_1800)
                {
                    masterSend.rollerHeight = SHITA;
                    kaeru_flag = true;
                }
            }else if(zyouge==3){
                if(GO_1800)
                {
                    masterSend.rollerHeight = UE;
                    Rota_FR.reset();
                    Rota_FL.reset();
                    Rota_RL.reset();
                    Rota_RR.reset();
                    rotarota_flag = true;
                    target_FR = 400;
                    target_FL = 300;
                    target_RL = -400;
                    target_RR = -300;
                    zyouge = 4;
                }else if(!GO_1800)
                {
                    masterSend.rollerHeight = MANNAKA;
                    kaeru_flag = true;
                }
            }else if(zyouge==4){
                masterSend.rollerHeight = MANNAKA;
                kaeru_flag = true;
            }
        }else if(redzone)
        {
            if(zyouge==2)
            {
                if(GO_1500)
                {
                    masterSend.rollerHeight = MANNAKA;
                    Rota_FR.reset();
                    Rota_FL.reset();
                    Rota_RL.reset();
                    Rota_RR.reset();
                    rotarota_flag = true;
                    target_FR = -300;
                    target_FL = -400;
                    target_RL = 300;
                    target_RR = 400;
                    zyouge = 3;
                }else if(!GO_1500 && GO_1800)
                {
                    masterSend.rollerHeight = UE;
                    Rota_FR.reset();
                    Rota_FL.reset();
                    Rota_RL.reset();
                    Rota_RR.reset();
                    rotarota_flag = true;
                    target_FR = -1000;
                    target_FL = -1100;
                    target_RL = 1000;
                    target_RR = 1100;
                    zyouge = 4;
                }else if(!GO_1500 && !GO_1800)
                {
                    masterSend.rollerHeight = MANNAKA;
                    kaeru_flag = true;
                }
            }else if(zyouge==3){
                if(GO_1800)
                {
                    masterSend.rollerHeight = UE;
                    Rota_FR.reset();
                    Rota_FL.reset();
                    Rota_RL.reset();
                    Rota_RR.reset();
                    
                    rotarota_flag = true;
                    target_FR = -300;
                    target_FL = -400;
                    target_RL = 300;
                    target_RR = 400;
                    zyouge = 4;
                }else if(!GO_1800)
                {
                    masterSend.rollerHeight = MANNAKA;
                    kaeru_flag = true;
                }
            }else if(zyouge==4){
                masterSend.rollerHeight = MANNAKA;
                kaeru_flag = true;
            }
        }
    }
    if(bluezone)
    {
        if(rotarota_flag)
        {
            motor[TIRE_FR].dir = SetStatus(pwm.FR);
            motor[TIRE_FL].dir = SetStatus(pwm.FL);
            motor[TIRE_RL].dir = SetStatus(pwm.RL);
            motor[TIRE_RR].dir = SetStatus(pwm.RR);
            motor[TIRE_FR].pwm = SetPWM(pwm.FR)*0.8;
            motor[TIRE_FL].pwm = SetPWM(pwm.FL)*0.3;
            motor[TIRE_RL].pwm = SetPWM(pwm.RL)*0.8;
            motor[TIRE_RR].pwm = SetPWM(pwm.RR)*0.3;
            if(dist.FR > (target_FR-100))
            {
                current = 8;
            }
        }
        if(kaeru_flag)
        {
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_RL].dir = BACK;
            motor[TIRE_RR].dir = BACK;
            motor[TIRE_FR].pwm = 40;
            motor[TIRE_FL].pwm = 100;
            motor[TIRE_RL].pwm = 40;
            motor[TIRE_RR].pwm = 100;
            masterSend.rollerHeight = MANNAKA;
        }
    }else if(redzone)
    {
        if(rotarota_flag)
        {
            motor[TIRE_FR].dir = SetStatus(pwm.FR);
            motor[TIRE_FL].dir = SetStatus(pwm.FL);
            motor[TIRE_RL].dir = SetStatus(pwm.RL);
            motor[TIRE_RR].dir = SetStatus(pwm.RR);
            motor[TIRE_FR].pwm = SetPWM(pwm.FR)*0.3;
            motor[TIRE_FL].pwm = SetPWM(pwm.FL)*0.8;
            motor[TIRE_RL].pwm = SetPWM(pwm.RL)*0.3;
            motor[TIRE_RR].pwm = SetPWM(pwm.RR)*0.8;
            if(dist.RR > (target_RR-100))
            {
                current = 8;
            }
        }
        if(kaeru_flag)
        {
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_RL].dir = FOR;
            motor[TIRE_RR].dir = FOR;
            motor[TIRE_FR].pwm = 100;
            motor[TIRE_FL].pwm = 40;
            motor[TIRE_RL].pwm = 100;
            motor[TIRE_RR].pwm = 40;
            masterSend.rollerHeight = MANNAKA;
        }
    }
    
    
}
#endif

#if USE_PROCESS_NUM>8
static void Process8()//ライン位置合わせ
{
    roller_flag = true;
    ColorDetection();
    Color_Changeflag();
    
    if (debug_flag1)
    {
        //zyouge++;
        on_line_flag = false;
        invation_FR = false;
        invation_FL = false;
        invation_RL = false;
        invation_RR = false; 
        debug_flag1 = false;
        ugoite_flag = false;
        flag = false;
        temae_flag = false;
        ok_flag = false;
    }
    
    Move_On_the_Line_BackTrace();
    
    if(on_line_flag)
    {
        if(LS_RL && LS_RR) 
        {
            AllBrake();
            current = 9;
            ok_flag = true;
        }else if(!LS_RL && LS_RR) 
        {
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_RL].dir = FOR;
            motor[TIRE_RR].dir = FOR;
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FL].pwm = 40;
            motor[TIRE_RL].pwm = 0;
            motor[TIRE_RR].pwm = 0;
        }else if(LS_RL && !LS_RR) 
        {
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_RL].dir = BACK;
            motor[TIRE_RR].dir = BACK;
            motor[TIRE_FR].pwm = 40;
            motor[TIRE_FL].pwm = 0;
            motor[TIRE_RL].pwm = 0;
            motor[TIRE_RR].pwm = 0;
        }else{
            GoBack();
        }
    }
    
    if(controller->Button.B){
        AllBrake();
        Rota_FR.reset();
        Rota_FL.reset();
        Rota_RL.reset();
        Rota_RR.reset();
        move_flag = false;
    }
}
#endif

#if USE_PROCESS_NUM>9
static void Process9()//ライントレースし、投射->Process6へ戻る
{
    once_flag = true;
    rotarota_flag = false;
    move_flag = false;
    Move_On_the_Line_Trace();
    if(LS_FL && LS_FR) 
    {
        target_FR = 0;
        target_FL = 0;
        target_RL = 0;
        target_RR = 0;
        dist.FR = 0;
        dist.FL = 0;
        dist.RL = 0;
        dist.RR = 0;
    
        masterSend.launch = true; 
        AllBrake();
        move_flag = false;
        if(roller_flag)
        {
            launchTimer.attach(launchTimer_func2, 3);
            roller_flag = false;
        }
    }else if(!LS_FL && LS_FR) {
        GoOshituke();
    }else if(LS_FL && !LS_FR) {
        GoOshituke();
    }
}
#endif
#endif
#pragma endregion PROCESS

static void AllActuatorReset()
{

#ifdef USE_SOLENOID
    solenoid.all = ALL_SOLENOID_OFF;
#endif

#ifdef USE_MOTOR
    for (uint8_t i = 0; i < MOUNTING_MOTOR_NUM; i++) {
        motor[i].dir = FREE;
        motor[i].pwm = 0x00;
    }
#endif
}

#pragma region USER-DEFINED-FUNCTIONS

void Get_Move()
{
    rps.FR = (rotate.FR-p_rps.FR)/0.1;
    rps.FL = (rotate.FL-p_rps.FL)/0.1;
    rps.RL = (rotate.RL-p_rps.RL)/0.1;
    rps.RR = (rotate.RR-p_rps.RR)/0.1;
    pwm_FR = (int)Catch_pwm_FR.SetPV(rps.FR , wantVal_FR);
    pwm_FL = (int)Catch_pwm_FL.SetPV(rps.FL , wantVal_FL);
    pwm_RL = (int)Catch_pwm_RL.SetPV(rps.RL , wantVal_RL);
    pwm_RR = (int)Catch_pwm_RR.SetPV(rps.RR , wantVal_RR);
    
    p_rps.FR = rotate.FR;
    p_rps.FL = rotate.FL;
    p_rps.RL = rotate.RL;
    p_rps.RR = rotate.RR;
}

void AllBrake()
 {
    motor[TIRE_FR].dir = BRAKE;
    motor[TIRE_FL].dir = BRAKE;
    motor[TIRE_RL].dir = BRAKE;
    motor[TIRE_RR].dir = BRAKE;
    motor[TIRE_FR].pwm = 255;
    motor[TIRE_FL].pwm = 255;
    motor[TIRE_RL].pwm = 255;
    motor[TIRE_RR].pwm = 255;
}

void GoOshituke()
{
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 48;
    motor[TIRE_FL].pwm = 48;
    motor[TIRE_RL].pwm = 48;
    motor[TIRE_RR].pwm = 48;
}
void GoFront()
{
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 48;
    motor[TIRE_FL].pwm = 48;
    motor[TIRE_RL].pwm = 48;
    motor[TIRE_RR].pwm = 48;
}

void GoMae()
{
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 29;
    motor[TIRE_FL].pwm = 32;
    motor[TIRE_RL].pwm = 35;
    motor[TIRE_RR].pwm = 37;
    
}
void GoBack()
{
    motor[TIRE_FR].dir = BACK;
    motor[TIRE_FL].dir = FOR;
    motor[TIRE_RL].dir = FOR;
    motor[TIRE_RR].dir = BACK;
    motor[TIRE_FR].pwm = 25;
    motor[TIRE_FL].pwm = 22;
    motor[TIRE_RL].pwm = 22;
    motor[TIRE_RR].pwm = 25;
}

void GoBack_Rota()
{
    if(once_flag)
    {
        dist.FR = 0;
        dist.FL = 0;
        dist.RL = 0;
        dist.RR = 0;
        Rota_FR.reset();
        Rota_FL.reset();
        Rota_RL.reset();
        Rota_RR.reset();
        target_FR = 8000;
        target_FL = -8000;
        target_RL = -8000;
        target_RR = 8000;
        once_flag = false;
    }
    
    motor[TIRE_FR].dir = SetStatus(pwm.FR);
    motor[TIRE_FL].dir = SetStatus(pwm.FL);
    motor[TIRE_RL].dir = SetStatus(pwm.RL);
    motor[TIRE_RR].dir = SetStatus(pwm.RR);
    motor[TIRE_FR].pwm = SetPWM(pwm.FR)*0.51;
    motor[TIRE_FL].pwm = SetPWM(pwm.FL)*0.52;
    motor[TIRE_RL].pwm = SetPWM(pwm.RL)*0.53;
    motor[TIRE_RR].pwm = SetPWM(pwm.RR)*0.47;
    
}

void GoLeft()
{
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = FOR;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = BACK;
    motor[TIRE_FR].pwm = 24;
    motor[TIRE_FL].pwm = 24;
    motor[TIRE_RL].pwm = 24;
    motor[TIRE_RR].pwm = 24;
}

void GoMigiNanameMae()
{
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 23;
    motor[TIRE_FL].pwm = 35;
    motor[TIRE_RL].pwm = 23;
    motor[TIRE_RR].pwm = 30;
}

void GoMigiNanameUshiro()
{
    motor[TIRE_FR].dir = BACK;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = FOR;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 30;
    motor[TIRE_FL].pwm = 0;
    motor[TIRE_RL].pwm = 30;
    motor[TIRE_RR].pwm = 0;
}

void GoRight()
{
    motor[TIRE_FR].dir = BACK;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = FOR;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 24;
    motor[TIRE_FL].pwm = 24;
    motor[TIRE_RL].pwm = 24;
    motor[TIRE_RR].pwm = 24;
}

void GoHidariNanameMae()
{
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 30;
    motor[TIRE_FL].pwm = 23;
    motor[TIRE_RL].pwm = 35;
    motor[TIRE_RR].pwm = 23;
}

void GoHidariNanameUshiro()
{
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = FOR;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = BACK;
    motor[TIRE_FR].pwm = 0;
    motor[TIRE_FL].pwm = 30;
    motor[TIRE_RL].pwm = 0;
    motor[TIRE_RR].pwm = 30;
}

void RightTurning()
{
    motor[TIRE_FR].dir = BACK;
    motor[TIRE_FL].dir = BACK;
    motor[TIRE_RL].dir = BACK;
    motor[TIRE_RR].dir = BACK;
    motor[TIRE_FR].pwm = 0;
    motor[TIRE_FL].pwm = 35;
    motor[TIRE_RL].pwm = 35;
    motor[TIRE_RR].pwm = 30;
}

void LeftTurning()
{
    motor[TIRE_FR].dir = FOR;
    motor[TIRE_FL].dir = FOR;
    motor[TIRE_RL].dir = FOR;
    motor[TIRE_RR].dir = FOR;
    motor[TIRE_FR].pwm = 30;
    motor[TIRE_FL].pwm = 0;
    motor[TIRE_RL].pwm = 35;
    motor[TIRE_RR].pwm = 30;
}

void Get_rps()
{
    rotate.FR = ((double)Rota_FR.getPulses()/(ROTATE_PER_REVOLUTIONS*4));
    rotate.FL = ((double)Rota_FL.getPulses()/(ROTATE_PER_REVOLUTIONS*4));
    rotate.RL = ((double)Rota_RL.getPulses()/(ROTATE_PER_REVOLUTIONS*4));
    rotate.RR = ((double)Rota_RR.getPulses()/(ROTATE_PER_REVOLUTIONS*4));

    dist.FR = 103.0*3.141*rotate.FR;
    dist.FL = 103.0*3.141*rotate.FL;
    dist.RL = 103.0*3.141*rotate.RL;
    dist.RR = 103.0*3.141*rotate.RR;
    
    pwm.FR = (int)Get_pwm_FR.SetPV(dist.FR , target_FR);
    pwm.FL = (int)Get_pwm_FL.SetPV(dist.FL , target_FL);
    pwm.RL = (int)Get_pwm_RL.SetPV(dist.RL , target_RL);
    pwm.RR = (int)Get_pwm_RR.SetPV(dist.RR , target_RR);
}

void Rota_SetStatus(char position,double percent)
{
    switch(position){
        case TIRE_FR :
                        wantVal_FR = (percent/100.0)*max_rotate;
                        //pwm_FR = (int)Catch_pwm_FR.SetPV(rps.FR , wantVal_FR);
                        motor[TIRE_FR].dir = SetStatus(pwm_FR);
                        motor[TIRE_FR].pwm = SetPWM(pwm_FR);
                        break;
        case TIRE_FL :
                        wantVal_FL = (percent/100.0)*max_rotate;
                        //pwm_FL = (int)Catch_pwm_FL.SetPV(rps.FL , wantVal_FL);
                        motor[TIRE_FL].dir = SetStatus(pwm_FL);
                        motor[TIRE_FL].pwm = SetPWM(pwm_FL);
                        break;
        case TIRE_RL :
                        wantVal_RL = (percent/100.0)*max_rotate;
                        //pwm_RL = (int)Catch_pwm_RL.SetPV(rps.RL , wantVal_RL);
                        motor[TIRE_RL].dir = SetStatus(pwm_RL);
                        motor[TIRE_RL].pwm = SetPWM(pwm_RL);
                        break;
        case TIRE_RR :
                        wantVal_RR = (percent/100.0)*max_rotate;
                        //pwm_RR = (int)Catch_pwm_RR.SetPV(rps.RR , wantVal_RR);
                        motor[TIRE_RR].dir = SetStatus(pwm_RR);
                        motor[TIRE_RR].pwm = SetPWM(pwm_RR);
                        break;
    }
}

uint8_t SetStatus(int pwmVal)
{
    if(pwmVal < 0) return BACK;
    else if(pwmVal > 0) return FOR;
    else return BRAKE;
}

uint8_t SetPWM(int pwmVal)
{
    if(pwmVal == 0 || pwmVal >  255 || pwmVal < -255) return 255;
    else return abs(pwmVal);
}
unsigned long ColorIn(int index)
{
    int result = 0;
    bool rtn = false;
    for(int i=0; i<12; i++)
    {
        CK = 1;
        rtn = DOUT[index];
        CK = 0;
        if(rtn)
        {
           result|=(1 << i);
        }
    }
    return result;
}

void ColorDetection(){
    GATE = 0;
           
    CK = 0;
        
    RANGE = 1;
        
    GATE = 1;
    wait_ms(intergration);
    GATE = 0;
    wait_us(4);
    switch(select++){
        case 0 :
                    Color_FR[0] = ColorIn(0); //赤
                    wait_us(3);
                    Color_FR[1] = ColorIn(0); //青
                    wait_us(3);
                    Color_FR[2] = ColorIn(0); //緑
                    break;
        case 1 :
                    Color_FL[0] = ColorIn(1);
                    wait_us(3);
                    Color_FL[1] = ColorIn(1);
                    wait_us(3);
                    Color_FL[2] = ColorIn(1);
                    break;
        case 2 :
                    Color_RL[0] = ColorIn(2);
                    wait_us(3);
                    Color_RL[1] = ColorIn(2);
                    wait_us(3);
                    Color_RL[2] = ColorIn(2);
                    break;
        case 3 :
                    Color_RR[0] = ColorIn(3);
                    wait_us(3);
                    Color_RR[1] = ColorIn(3);
                    wait_us(3);
                    Color_RR[2] = ColorIn(3);
                    select = 0;
                    break;
    }    
}

void Color_Changeflag(){
    ColorDetection();
    
    if(Color_FR[0] > line_FR[0] && Color_FR[1] > line_FR[1] && Color_FR[2] > line_FR[2] && !white_FR)//白
    {
    //invation_FR ^= 1;//start false,over true
    white_FR = true;//on true,noon false
    }   
    else if(!(Color_FR[0] > line_FR[0] && Color_FR[1] > line_FR[1] && Color_FR[2] > line_FR[2]))white_FR = false;//茶
    
    if(Color_FL[0] > line_FL[0] && Color_FL[1] > line_FL[1] && Color_FL[2] > line_FL[2] && !white_FL)//白
    {
    //invation_FL ^= 1;//start false,over true
    white_FL = true;//on true,noon false
    }   
    else if(!(Color_FL[0] > line_FL[0] && Color_FL[1] > line_FL[1] && Color_FL[2] > line_FL[2]))white_FL = false;//茶
    
    if(Color_RL[0] > line_RL[0] && Color_RL[1] > line_RL[1] && Color_RL[2] > line_RL[2] && !white_RL)//白
    {
    //invation_RL ^= 1;//start false,over true
    white_RL = true;//on true,noon false
    }   
    else if(!(Color_RL[0] > line_RL[0] && Color_RL[1] > line_RL[1] && Color_RL[2] > line_RL[2]))white_RL = false;//茶

    if(Color_RR[0] > line_RR[0] && Color_RR[1] > line_RR[1] && Color_RR[2] > line_RR[2] && !white_RR)//白
    {
    //invation_RR ^= 1;//start false,over true
    white_RR = true;//on true,noon false
    }   
    else if(!(Color_RR[0] > line_RR[0] && Color_RR[1] > line_RR[1] && Color_RR[2] > line_RR[2]))white_RR = false;//茶
}

void Move_On_the_Line()
{
    Color_Changeflag();
    if(bluezone)
    {
        if(white_FL && !white_FR)
        {
            GoLeft();
            invation_FL = false;
            invation_FR = true;
            on_line_flag = false;
        }
        if(!white_FL && white_FR)
        {
            GoRight();
            invation_FL = false;
            invation_FR = false;
            on_line_flag = false;
        }
        if(!white_FL && !white_FR)
        {
            if(!white_RR)
            {
                if(invation_FR)
                {
                    GoLeft();
                    on_line_flag = false;
                }else if(!invation_FR)
                {
                    GoRight();
                    on_line_flag = false;
                }
            }
        }
        if(white_RR)
        {
            GoMae();
            on_line_flag = true;    
        }
    }else if(redzone)
    {
        
        if(white_FL && !white_FR)
        {
            GoLeft();
            invation_FL = false;
            invation_FR = false;
            on_line_flag = false;
        }
        if(white_FR && !white_FL)
        {
            GoRight();
            invation_FL = true;
            invation_FR = false;
            on_line_flag = false;
        }
        if(!white_FL && !white_FR)
        {
            if(!white_RR)
            {
                if(invation_FL)
                {
                    GoRight();
                    on_line_flag = false;
                }else if(!invation_FL)
                {
                    GoLeft();
                    on_line_flag = false;
                }
            }
        }
        if(white_RR)
        {
            GoMae();
            on_line_flag = true;    
        }
    }
}
void Move_On_the_Line_Trace()
{
    Color_Changeflag();
    if(bluezone)
    {
        if(white_FL && !white_FR && !white_RR)//右に行きすぎ
        {
            invation_FR = true;
            invation_FL = false;
            invation_RR = true;
            GoHidariNanameMae();
            on_line_flag = false;
        }else if(!white_FL && white_FR && !white_RR)//左に行き過ぎ
        {
            invation_FR = false;
            invation_FL = false;
            invation_RR = false;
            GoMigiNanameMae();
            on_line_flag = false;
        }else if(!white_FL && !white_FR && !white_RR)//線の右か左
        {
            if(!invation_FL && !invation_FR && !invation_RR)
            {
                GoMigiNanameMae();
                on_line_flag = false;
                
            }
            if(invation_FL && invation_FR && invation_RR)
            {
                GoHidariNanameMae();
                on_line_flag = false;
            }
        }else if(white_FL && !white_FR && white_RR)//ちょい右
        {
            invation_FR = true;
            invation_FL = false;
            invation_RR = false; 
            GoHidariNanameMae();            
            on_line_flag = false;
        }else if(!white_FL && white_FR && white_RR)//ちょい左
        {
            invation_FR = true;
            invation_FL = false;
            invation_RR = true;
            GoMigiNanameMae();
            on_line_flag = false;
        }else if(white_FL && white_FR && !white_RR)//機体が斜め
        {
            if(invation_RR)
            {
                GoMae();
                on_line_flag = false;
            }
            if(!invation_RR)
            {
                GoMae();
                on_line_flag  = false;
            }
        }else if(white_FL && white_FR && white_RR)//十字の時
        {
            GoMae();
            on_line_flag  = true;
        }else if(!white_FL && !white_FR && white_RR)//OK
        {
            GoMae();
            on_line_flag  = true;
        }
    }else if(redzone)
    {
        if(white_FL && !white_FR && !white_RR)//右に行きすぎ
        {
            invation_FR = false;
            invation_FL = false;
            invation_RR = false;
            GoHidariNanameMae();
            on_line_flag = false;
        }else if(!white_FL && white_FR && !white_RR)//左に行き過ぎ
        {
            invation_FR = false;
            invation_FL = true;
            invation_RR = true;
            GoMigiNanameMae();
            on_line_flag = false;
        }else if(!white_FL && !white_FR && !white_RR)//線の右か左
        {
            if(!invation_FL && !invation_FR && !invation_RR)
            {
                GoHidariNanameMae();
                on_line_flag = false;
                
            }
            if(invation_FL && invation_FR && invation_RR)
            {
                GoMigiNanameMae();
                on_line_flag = false;
            }
        }else if(white_FL && !white_FR && white_RR)//ちょい右
        {
            invation_FR = false;
            invation_FL = false;
            invation_RR = false; 
            GoHidariNanameMae();            
            on_line_flag = false;
        }else if(!white_FL && white_FR && white_RR)//ちょい左
        {
            invation_FR = false;
            invation_FL = true;
            invation_RR = false;
            GoMigiNanameMae();
            on_line_flag = false;
        }else if(white_FL && white_FR && !white_RR)//機体が斜め
        {
            if(invation_RR)
            {
                GoMae();
                on_line_flag = false;
            }
            if(!invation_RR)
            {
                GoMae();
                on_line_flag  = false;
            }
        }else if(white_FL && white_FR && white_RR)//十字の時
        {
            GoMae();
            on_line_flag  = true;
        }else if(!white_FL && !white_FR && white_RR)//OK
        {
            GoMae();
            on_line_flag  = true;
        }
    }
}

void Move_On_the_Line_BackTrace()
{
    Color_Changeflag();
    if(bluezone)
    {
        if(white_FL && !white_FR && !white_RR)//右に行きすぎ
        {
            invation_FR = true;
            invation_FL = false;
            invation_RR = true;
            GoHidariNanameUshiro();
            on_line_flag = false;
        }else if(!white_FL && white_FR && !white_RR)//左に行き過ぎ
        {
            invation_FR = false;
            invation_FL = false;
            invation_RR = false;
            GoMigiNanameUshiro();
            on_line_flag = false;
        }else if(!white_FL && !white_FR && !white_RR)//線の右か左
        {
            if(!invation_FL && !invation_FR && !invation_RR)
            {
                GoMigiNanameUshiro();
                on_line_flag = false;
                
            }
            if(invation_FL && invation_FR && invation_RR)
            {
                GoHidariNanameUshiro();
                on_line_flag = false;
            }
        }else if(white_FL && !white_FR && white_RR)//ちょい右
        {
            invation_FR = true;
            invation_FL = false;
            invation_RR = false; 
            GoHidariNanameUshiro();            
            on_line_flag = false;
        }else if(!white_FL && white_FR && white_RR)//ちょい左
        {
            invation_FR = true;
            invation_FL = false;
            invation_RR = true;
            GoMigiNanameUshiro();
            on_line_flag = false;
        }else if(white_FL && white_FR && !white_RR)//機体が斜め
        {
            if(invation_RR)
            {
                RightTurning();
                on_line_flag = false;
            }
            if(!invation_RR)
            {
                LeftTurning();
                on_line_flag  = false;
            }
        }else if(white_FL && white_FR && white_RR)//十字の時
        {
            GoBack();
            on_line_flag  = true;
        }else if(!white_FL && !white_FR && white_RR)//OK
        {
            GoBack();
            on_line_flag  = true;
        }
    }else if(redzone)
    {
        if(white_FL && !white_FR && !white_RR)//右に行きすぎ
        {
            invation_FR = false;
            invation_FL = false;
            invation_RR = false;
            GoHidariNanameUshiro();
            on_line_flag = false;
        }else if(!white_FL && white_FR && !white_RR)//左に行き過ぎ
        {
            invation_FR = false;
            invation_FL = true;
            invation_RR = true;
            GoMigiNanameUshiro();
            on_line_flag = false;
        }else if(!white_FL && !white_FR && !white_RR)//線の右か左
        {
            if(!invation_FL && !invation_FR && !invation_RR)
            {
                GoHidariNanameUshiro();
                on_line_flag = false;
                
            }
            if(invation_FL && invation_FR && invation_RR)
            {
                GoMigiNanameUshiro();
                on_line_flag = false;
            }
        }else if(white_FL && !white_FR && white_RR)//ちょい右
        {
            invation_FR = false;
            invation_FL = false;
            invation_RR = false; 
            GoHidariNanameUshiro();            
            on_line_flag = false;
        }else if(!white_FL && white_FR && white_RR)//ちょい左
        {
            invation_FR = false;
            invation_FL = true;
            invation_RR = false;
            GoMigiNanameUshiro();
            on_line_flag = false;
        }else if(white_FL && white_FR && !white_RR)//機体が斜め
        {
            if(invation_RR)
            {
                LeftTurning();
                on_line_flag = false;
            }
            if(!invation_RR)
            {
                RightTurning();
                on_line_flag  = false;
            }
        }else if(white_FL && white_FR && white_RR)//十字の時
        {
            GoBack();
            on_line_flag  = true;
        }else if(!white_FL && !white_FR && white_RR)//OK
        {
            GoBack();
            on_line_flag  = true;
        }
    }
}
void BuzzerTimer_func()
{
    buzzer = !buzzer;
}

void launchTimer_func() {
    
    current = 2;
}
void launchTimer_func1(){
    //masterSend.launch = true;
    current = 6;
}
void launchTimer_func2()
{
    //masterSend.launch = true;
    current = 6;
}
#pragma endregion