#include "Initialize.h"
#include "../Using.h"

#include "../../Input/Switch/Switch.h"
#include "../../Communication/Controller/Mu/Mu.h"
#include "../../Communication/Controller/Controller.h"
#include "../../Communication/RS485/ActuatorHub/ActuatorHub.h"
#include "../../Communication/RS485/Master/Master.h"
#include "../../Communication/RS485/RS485.h"
#include "../../Input/Switch/Switch.h"
#include "../../LED/LED.h"

void SystemInitialize() {
    #ifdef USE_SWITCH
    SWITCH::DipSw::Initialize();
    SWITCH::LimitSw::Initialize();
    SWITCH::PushSw::Initialize();
    #endif

    #ifdef USE_MU
    MU::Mu::Initialize(SWITCH::DipSw::GetStatus());
    CONTROLLER::Controller::Initialize();
    #endif

    #ifdef USE_LED
    LED::LED::Initialize();
    #endif

    #ifdef USE_RS485
    MASTER::Master::Initialize();    
    RS485::RS485::Initialize();
    #endif

    #ifdef USE_MOTOR
    ACTUATORHUB::MOTOR::Motor::Initialize();
    #endif

    #ifdef USE_SOLENOID
    ACTUATORHUB::SOLENOID::Solenoid::Initialize();
    #endif

    __enable_irq();
}

