#ifndef SWITCH_H_
#define SWITCH_H_

#include "mbed.h"
#include <stdint.h>

namespace SWITCH {
    #define SW_ON   0
    #define SW_OFF  1

    #define DIP0_PIN    PA_15
    #define DIP1_PIN    PB_7
    #define DIP2_PIN    PC_13
    #define DIP3_PIN    PH_1

    #define LS_PIN      PA_6
    #define SELECT0_PIN PC_8
    #define SELECT1_PIN PC_9
    #define SELECT2_PIN PB_8
    #define SELECT3_PIN PB_9

    #define DIP0    dipSw[0]
    #define DIP1    dipSw[1]
    #define DIP2    dipSw[2]
    #define DIP3    dipSw[3]
    
    #define SW0_PIN PB_15
    #define SW1_PIN PB_2
    #define SW2_PIN PB_3
    #define SW3_PIN PB_1
    #define SW4_PIN PB_5
    
    class DipSw {
        public:
        static void Initialize();
        static uint8_t GetStatus();
    };
    
    class LimitSw {
        public:
        static void Initialize();
        static bool IsPressed(uint8_t index);
    };
    
    class PushSw {
        public:
        static void Initialize();
        static bool IsPressed(uint8_t index);
    };

    typedef union {
        struct {
            int s0 : 1;
            int s1 : 1;
            int s2 : 1;
            int s3 : 1;
            int : 4;
        };
        uint8_t all;
    } MP_Channel;
}

#endif

