#include "Switch.h"

#include <stdint.h>
#include "mbed.h"

namespace SWITCH {
    DigitalIn dipSw[] = {
        DigitalIn(DIP0_PIN),
        DigitalIn(DIP1_PIN),
        DigitalIn(DIP2_PIN),
        DigitalIn(DIP3_PIN),
    };

    DigitalIn limitSw(LS_PIN);
    DigitalOut selectPin[] = {
        DigitalOut(SELECT0_PIN),
        DigitalOut(SELECT1_PIN),
        DigitalOut(SELECT2_PIN),
        DigitalOut(SELECT3_PIN),
    };
    
    DigitalIn pushSw[] = {
        DigitalIn(SW0_PIN),
        DigitalIn(SW1_PIN),
        DigitalIn(SW2_PIN),
        DigitalIn(SW3_PIN),
        DigitalIn(SW4_PIN),
    };

    void DipSw::Initialize() {
        for(uint8_t i=0; i < sizeof(dipSw)/sizeof(dipSw[0]); i++) {
            dipSw[i].mode(PullUp);
        }
    }

    uint8_t DipSw::GetStatus() {
        if(DIP0 == SW_ON)       return 0;
        else if(DIP1 == SW_ON)  return 1;
        else if(DIP2 == SW_ON)  return 2;
        else if(DIP3 == SW_ON)  return 3;

        return 0;
    }

    void LimitSw::Initialize() {
        for(uint8_t i=0; i<4; i++) selectPin[i] = 0;
        limitSw.mode(PullUp);
    }

    bool LimitSw::IsPressed(uint8_t index) {
        // if(index > 0x0f) return false;
        MP_Channel ch;
        ch.all = 15-index;

        selectPin[0] = ch.s0;
        selectPin[1] = ch.s1;
        selectPin[2] = ch.s2;
        selectPin[3] = ch.s3;

        // while(1);
        wait_us(10);
        
        return limitSw ? false : true;
    }
    
    void PushSw::Initialize() {
        for(uint8_t i=0; i<4; i++) pushSw[i].mode(PullUp);
        pushSw[4].mode(PullNone);
    }

    bool PushSw::IsPressed(uint8_t index) {
        return pushSw[index] ? false : true;
    }
}

